/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.regressions.logistic;

import java.util.Arrays;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.impl.DenseVector;
import org.apache.ignite.ml.nn.Activators;
import org.apache.ignite.ml.nn.MLPTrainer;
import org.apache.ignite.ml.nn.MultilayerPerceptron;
import org.apache.ignite.ml.nn.UpdatesStrategy;
import org.apache.ignite.ml.nn.architecture.MLPArchitecture;
import org.apache.ignite.ml.optimization.LossFunctions;
import org.apache.ignite.ml.optimization.SmoothParametrized;
import org.apache.ignite.ml.optimization.updatecalculators.SimpleGDParameterUpdate;
import org.apache.ignite.ml.optimization.updatecalculators.SimpleGDUpdateCalculator;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.preprocessing.developer.PatchedPreprocessor;
import org.apache.ignite.ml.regressions.logistic.LogisticRegressionModel;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.trainers.DatasetTrainer;
import org.apache.ignite.ml.trainers.SingleLabelDatasetTrainer;
import org.jetbrains.annotations.NotNull;

public class LogisticRegressionSGDTrainer
extends SingleLabelDatasetTrainer<LogisticRegressionModel> {
    private UpdatesStrategy updatesStgy = new UpdatesStrategy<SmoothParametrized, SimpleGDParameterUpdate>(new SimpleGDUpdateCalculator(0.2), SimpleGDParameterUpdate.SUM_LOCAL, SimpleGDParameterUpdate.AVG);
    private int maxIterations = 100;
    private int batchSize = 100;
    private int locIterations = 100;
    private long seed = 1234L;

    @Override
    public <K, V> LogisticRegressionModel fitWithInitializedDeployingContext(DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> extractor) {
        return this.updateModel((LogisticRegressionModel)null, datasetBuilder, extractor);
    }

    @Override
    protected <K, V> LogisticRegressionModel updateModel(LogisticRegressionModel mdl, DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> extractor) {
        MultilayerPerceptron mlp;
        IgniteFunction archSupplier = dataset -> {
            Integer cols = (Integer)dataset.compute(data -> {
                if (data.getFeatures() == null) {
                    return null;
                }
                return data.getFeatures().length / data.getRows();
            }, (a, b) -> {
                if (a == null) {
                    return b;
                }
                return a;
            });
            if (cols == null) {
                throw new IllegalStateException("Cannot train on empty dataset");
            }
            MLPArchitecture architecture = new MLPArchitecture(cols);
            architecture = architecture.withAddedLayer(1, true, Activators.SIGMOID);
            return architecture;
        };
        DatasetTrainer trainer = new MLPTrainer(archSupplier, LossFunctions.L2, this.updatesStgy, this.maxIterations, this.batchSize, this.locIterations, this.seed).withEnvironmentBuilder(this.envBuilder);
        IgniteFunction func = lv -> new LabeledVector<double[]>((Vector)lv.features(), new double[]{(Double)lv.label()});
        PatchedPreprocessor patchedPreprocessor = new PatchedPreprocessor(func, extractor);
        if (mdl != null) {
            mlp = this.restoreMLPState(mdl);
            mlp = trainer.update(mlp, datasetBuilder, patchedPreprocessor);
        } else {
            mlp = (MultilayerPerceptron)trainer.fit(datasetBuilder, patchedPreprocessor);
        }
        double[] params = mlp.parameters().getStorage().data();
        return new LogisticRegressionModel(new DenseVector(Arrays.copyOf(params, params.length - 1)), params[params.length - 1]);
    }

    @NotNull
    private MultilayerPerceptron restoreMLPState(LogisticRegressionModel mdl) {
        Vector weights = mdl.weights();
        double intercept = mdl.intercept();
        MLPArchitecture architecture1 = new MLPArchitecture(weights.size());
        MLPArchitecture architecture = architecture1 = architecture1.withAddedLayer(1, true, Activators.SIGMOID);
        MultilayerPerceptron perceptron = new MultilayerPerceptron(architecture);
        Vector mlpState = weights.like(weights.size() + 1);
        weights.nonZeroes().forEach(ith -> mlpState.set(ith.index(), ith.get()));
        mlpState.set(mlpState.size() - 1, intercept);
        perceptron.setParameters(mlpState);
        return perceptron;
    }

    @Override
    public boolean isUpdateable(LogisticRegressionModel mdl) {
        return true;
    }

    public LogisticRegressionSGDTrainer withMaxIterations(double maxIterations) {
        this.maxIterations = (int)maxIterations;
        return this;
    }

    public LogisticRegressionSGDTrainer withBatchSize(double batchSize) {
        this.batchSize = (int)batchSize;
        return this;
    }

    public LogisticRegressionSGDTrainer withLocIterations(double amountOfLocIterations) {
        this.locIterations = (int)amountOfLocIterations;
        return this;
    }

    public LogisticRegressionSGDTrainer withSeed(long seed) {
        this.seed = seed;
        return this;
    }

    public LogisticRegressionSGDTrainer withUpdatesStgy(UpdatesStrategy updatesStgy) {
        this.updatesStgy = updatesStgy;
        return this;
    }

    public UpdatesStrategy getUpdatesStgy() {
        return this.updatesStgy;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getLocIterations() {
        return this.locIterations;
    }

    public long getSeed() {
        return this.seed;
    }
}

