/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.naivebayes.gaussian;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.naivebayes.BayesModel;
import org.apache.ignite.ml.naivebayes.gaussian.GaussianNaiveBayesSumsHolder;

public class GaussianNaiveBayesModel
implements BayesModel<GaussianNaiveBayesModel, Vector, Double>,
DeployableObject {
    private static final long serialVersionUID = -127386523291350345L;
    private final double[][] means;
    private final double[][] variances;
    private final double[] classProbabilities;
    private final double[] labels;
    private final GaussianNaiveBayesSumsHolder sumsHolder;

    public GaussianNaiveBayesModel(double[][] means, double[][] variances, double[] classProbabilities, double[] labels, GaussianNaiveBayesSumsHolder sumsHolder) {
        this.means = means;
        this.variances = variances;
        this.classProbabilities = classProbabilities;
        this.labels = labels;
        this.sumsHolder = sumsHolder;
    }

    @Override
    public <P> void saveModel(Exporter<GaussianNaiveBayesModel, P> exporter, P path) {
        exporter.save(this, path);
    }

    @Override
    public Double predict(Vector vector) {
        double[] probabilityPowers = this.probabilityPowers(vector);
        int max = 0;
        for (int i = 0; i < probabilityPowers.length; ++i) {
            int n = i;
            probabilityPowers[n] = probabilityPowers[n] + Math.log(this.classProbabilities[i]);
            if (!(probabilityPowers[i] > probabilityPowers[max])) continue;
            max = i;
        }
        return this.labels[max];
    }

    @Override
    public double[] probabilityPowers(Vector vector) {
        double[] probabilityPowers = new double[this.classProbabilities.length];
        for (int i = 0; i < this.classProbabilities.length; ++i) {
            for (int j = 0; j < vector.size(); ++j) {
                double x = vector.get(j);
                double probability = GaussianNaiveBayesModel.gauss(x, this.means[i][j], this.variances[i][j]);
                int n = i;
                probabilityPowers[n] = probabilityPowers[n] + (probability > 0.0 ? Math.log(probability) : 0.0);
            }
        }
        return probabilityPowers;
    }

    public double[][] getMeans() {
        return this.means;
    }

    public double[][] getVariances() {
        return this.variances;
    }

    public double[] getClassProbabilities() {
        return this.classProbabilities;
    }

    public double[] getLabels() {
        return this.labels;
    }

    public GaussianNaiveBayesSumsHolder getSumsHolder() {
        return this.sumsHolder;
    }

    private static double gauss(double x, double mean, double variance) {
        return Math.exp(-1.0 * Math.pow(x - mean, 2.0) / (2.0 * variance)) / Math.sqrt(Math.PI * 2 * variance);
    }

    @Override
    public List<Object> getDependencies() {
        return Collections.emptyList();
    }
}

