/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.environment.parallelism;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.ml.environment.parallelism.ParallelismStrategy;
import org.apache.ignite.ml.environment.parallelism.Promise;
import org.apache.ignite.ml.math.functions.IgniteSupplier;
import org.jetbrains.annotations.NotNull;

public class DefaultParallelismStrategy
implements ParallelismStrategy {
    private ExecutorService pool = Executors.newWorkStealingPool(4);

    @Override
    public <T> Promise<T> submit(IgniteSupplier<T> task) {
        return new FutureWrapper<Object>(this.pool.submit(task::get));
    }

    @Override
    public int getParallelism() {
        return ((ForkJoinPool)this.pool).getParallelism();
    }

    public static class FutureWrapper<T>
    implements Promise<T> {
        private final Future<T> f;

        public FutureWrapper(Future<T> f) {
            this.f = f;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.f.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.f.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.f.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.f.get();
        }

        @Override
        public T get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.f.get(timeout, unit);
        }
    }
}

