/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

class SSLServerSocketFactoryWrapper
extends SSLServerSocketFactory {
    private final SSLServerSocketFactory delegate;
    private final SSLParameters parameters;

    SSLServerSocketFactoryWrapper(SSLServerSocketFactory delegate, SSLParameters parameters) {
        this.delegate = delegate;
        this.parameters = parameters;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket srvSock = (SSLServerSocket)this.delegate.createServerSocket(port);
        if (this.parameters != null) {
            srvSock.setSSLParameters(this.parameters);
        }
        return srvSock;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket srvSock = (SSLServerSocket)this.delegate.createServerSocket(port, backlog);
        srvSock.setSSLParameters(this.parameters);
        return srvSock;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress locAddr) throws IOException {
        SSLServerSocket srvSock = (SSLServerSocket)this.delegate.createServerSocket(port, backlog, locAddr);
        if (this.parameters != null) {
            srvSock.setSSLParameters(this.parameters);
        }
        return srvSock;
    }
}

