/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.misc;

import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisorNopTask
implements ComputeTask<Integer, Void> {
    private static final long serialVersionUID = 0L;

    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Integer arg) {
        GridLeanMap<VisorNopJob, ClusterNode> map = new GridLeanMap<VisorNopJob, ClusterNode>(subgrid.size());
        for (ClusterNode node : subgrid) {
            map.put(new VisorNopJob((Object)arg), node);
        }
        return map;
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        return ComputeJobResultPolicy.WAIT;
    }

    @Override
    @Nullable
    public Void reduce(List<ComputeJobResult> results) {
        return null;
    }

    private static class VisorNopJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;

        private VisorNopJob(@Nullable Object arg) {
            super(arg);
        }

        @Override
        @Nullable
        public Object execute() {
            try {
                Integer maxTimeout = (Integer)this.argument(0);
                Thread.sleep(new Random().nextInt(maxTimeout));
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            return null;
        }

        public String toString() {
            return S.toString(VisorNopJob.class, this);
        }
    }
}

