/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.jetbrains.annotations.NotNull;

public class PageMetaIO
extends PageIO {
    private static final int TREE_ROOT_OFF = 48;
    private static final int REUSE_LIST_ROOT_OFF = 56;
    private static final int LAST_SUCCESSFUL_SNAPSHOT_ID_OFF = 64;
    private static final int LAST_SUCCESSFUL_FULL_SNAPSHOT_ID_OFF = 72;
    private static final int NEXT_SNAPSHOT_TAG_OFF = 80;
    private static final int LAST_SUCCESSFUL_FULL_SNAPSHOT_TAG_OFF = 88;
    private static final int LAST_PAGE_COUNT_OFF = 96;
    private static final int CANDIDATE_PAGE_COUNT_OFF = 100;
    static final int END_OF_PAGE_META = 104;
    public static final IOVersions<PageMetaIO> VERSIONS = new IOVersions((PageIO[])new PageMetaIO[]{new PageMetaIO(1)});

    public PageMetaIO(int ver) {
        super(11, ver);
    }

    protected PageMetaIO(int type, int ver) {
        super(type, ver);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        super.initNewPage(pageAddr, pageId, pageSize);
        this.setTreeRoot(pageAddr, 0L);
        this.setReuseListRoot(pageAddr, 0L);
        this.setLastSuccessfulFullSnapshotId(pageAddr, 0L);
        this.setLastSuccessfulSnapshotId(pageAddr, 0L);
        this.setNextSnapshotTag(pageAddr, 1L);
        this.setLastSuccessfulSnapshotTag(pageAddr, 0L);
        this.setLastAllocatedPageCount(pageAddr, 0);
        this.setCandidatePageCount(pageAddr, 0);
    }

    public long getTreeRoot(long pageAddr) {
        return PageUtils.getLong(pageAddr, 48);
    }

    public void setTreeRoot(long pageAddr, long treeRoot) {
        PageUtils.putLong(pageAddr, 48, treeRoot);
    }

    public long getReuseListRoot(long pageAddr) {
        return PageUtils.getLong(pageAddr, 56);
    }

    public void setReuseListRoot(long pageAddr, long pageId) {
        PageUtils.putLong(pageAddr, 56, pageId);
    }

    @Deprecated
    public void setLastSuccessfulSnapshotId(long pageAddr, long lastSuccessfulSnapshotId) {
        PageUtils.putLong(pageAddr, 64, lastSuccessfulSnapshotId);
    }

    @Deprecated
    public long getLastSuccessfulSnapshotId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 64);
    }

    @Deprecated
    public void setLastSuccessfulFullSnapshotId(long pageAddr, long lastSuccessfulFullSnapshotId) {
        PageUtils.putLong(pageAddr, 72, lastSuccessfulFullSnapshotId);
    }

    @Deprecated
    public long getLastSuccessfulFullSnapshotId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 72);
    }

    @Deprecated
    public void setNextSnapshotTag(long pageAddr, long nextSnapshotTag) {
        PageUtils.putLong(pageAddr, 80, nextSnapshotTag);
    }

    @Deprecated
    public long getLastSuccessfulSnapshotTag(long pageAddr) {
        return PageUtils.getLong(pageAddr, 88);
    }

    @Deprecated
    public void setLastSuccessfulSnapshotTag(long pageAddr, long lastSuccessfulSnapshotTag) {
        PageUtils.putLong(pageAddr, 88, lastSuccessfulSnapshotTag);
    }

    @Deprecated
    public long getNextSnapshotTag(long pageAddr) {
        return PageUtils.getLong(pageAddr, 80);
    }

    public void setLastAllocatedPageCount(long pageAddr, int pageCnt) {
        PageUtils.putInt(pageAddr, 96, pageCnt);
    }

    public int getLastAllocatedPageCount(@NotNull ByteBuffer buf) {
        return buf.getInt(96);
    }

    public int getLastAllocatedPageCount(long pageAddr) {
        return PageUtils.getInt(pageAddr, 96);
    }

    public boolean setCandidatePageCount(long pageAddr, int pageCnt) {
        if (this.getCandidatePageCount(pageAddr) == pageCnt) {
            return false;
        }
        PageUtils.putInt(pageAddr, 100, pageCnt);
        return true;
    }

    public int getCandidatePageCount(long pageAddr) {
        return PageUtils.getInt(pageAddr, 100);
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        sb.a("PageMeta[\n\ttreeRoot=").a(this.getReuseListRoot(addr)).a(",\n\tlastSuccessfulFullSnapshotId=").a(this.getLastSuccessfulFullSnapshotId(addr)).a(",\n\tlastSuccessfulSnapshotId=").a(this.getLastSuccessfulSnapshotId(addr)).a(",\n\tnextSnapshotTag=").a(this.getNextSnapshotTag(addr)).a(",\n\tlastSuccessfulSnapshotTag=").a(this.getLastSuccessfulSnapshotTag(addr)).a(",\n\tlastAllocatedPageCount=").a(this.getLastAllocatedPageCount(addr)).a(",\n\tcandidatePageCount=").a(this.getCandidatePageCount(addr)).a("\n]");
    }
}

