/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntry;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class CheckpointHistory {
    private final IgniteLogger log;
    private final GridCacheSharedContext<?, ?> cctx;
    private final NavigableMap<Long, CheckpointEntry> histMap = new ConcurrentSkipListMap<Long, CheckpointEntry>();
    private final int maxCpHistMemSize;
    private final boolean isWalHistorySizeParameterEnabled;

    public CheckpointHistory(GridKernalContext ctx) {
        this.cctx = ctx.cache().context();
        this.log = ctx.log(this.getClass());
        DataStorageConfiguration dsCfg = ctx.config().getDataStorageConfiguration();
        this.maxCpHistMemSize = Math.min(dsCfg.getWalHistorySize(), IgniteSystemProperties.getInteger("IGNITE_PDS_MAX_CHECKPOINT_MEMORY_HISTORY_SIZE", 100));
        this.isWalHistorySizeParameterEnabled = dsCfg.isWalHistorySizeParameterUsed();
    }

    public void initialize(List<CheckpointEntry> checkpoints) {
        for (CheckpointEntry e : checkpoints) {
            this.histMap.put(e.timestamp(), e);
        }
    }

    private CheckpointEntry entry(Long cpTs) throws IgniteCheckedException {
        CheckpointEntry entry = (CheckpointEntry)this.histMap.get(cpTs);
        if (entry == null) {
            throw new IgniteCheckedException("Checkpoint entry was removed: " + cpTs);
        }
        return entry;
    }

    public CheckpointEntry firstCheckpoint() {
        Map.Entry<Long, CheckpointEntry> entry = this.histMap.firstEntry();
        return entry != null ? entry.getValue() : null;
    }

    public CheckpointEntry lastCheckpoint() {
        Map.Entry<Long, CheckpointEntry> entry = this.histMap.lastEntry();
        return entry != null ? entry.getValue() : null;
    }

    public WALPointer firstCheckpointPointer() {
        CheckpointEntry entry = this.firstCheckpoint();
        return entry != null ? entry.checkpointMark() : null;
    }

    public Collection<Long> checkpoints(boolean descending) {
        if (descending) {
            return this.histMap.descendingKeySet();
        }
        return this.histMap.keySet();
    }

    public Collection<Long> checkpoints() {
        return this.checkpoints(false);
    }

    public void addCheckpoint(CheckpointEntry entry) {
        this.histMap.put(entry.timestamp(), entry);
    }

    public boolean hasSpace() {
        return this.histMap.size() + 1 <= this.maxCpHistMemSize;
    }

    public List<CheckpointEntry> onWalTruncated(WALPointer ptr) {
        CheckpointEntry cpEntry;
        FileWALPointer cpPnt;
        ArrayList<CheckpointEntry> removed = new ArrayList<CheckpointEntry>();
        FileWALPointer highBound = (FileWALPointer)ptr;
        Iterator iterator = this.histMap.values().iterator();
        while (iterator.hasNext() && highBound.compareTo(cpPnt = (FileWALPointer)(cpEntry = (CheckpointEntry)iterator.next()).checkpointMark()) > 0) {
            if (this.cctx.wal().reserved(cpEntry.checkpointMark())) {
                U.warn(this.log, "Could not clear historyMap due to WAL reservation on cp: " + cpEntry + ", history map size is " + this.histMap.size());
                break;
            }
            this.histMap.remove(cpEntry.timestamp());
            removed.add(cpEntry);
        }
        return removed;
    }

    public List<CheckpointEntry> onCheckpointFinished(GridCacheDatabaseSharedManager.Checkpoint chp, boolean truncateWal) {
        WALPointer checkpointMarkUntilDel;
        chp.walSegsCoveredRange(this.calculateWalSegmentsCovered());
        WALPointer wALPointer = checkpointMarkUntilDel = this.isWalHistorySizeParameterEnabled ? this.checkpointMarkUntilDeleteByMemorySize() : this.newerPointer(this.checkpointMarkUntilDeleteByMemorySize(), this.checkpointMarkUntilDeleteByArchiveSize());
        if (checkpointMarkUntilDel == null) {
            return Collections.emptyList();
        }
        List<CheckpointEntry> deletedCheckpoints = this.onWalTruncated(checkpointMarkUntilDel);
        int deleted = 0;
        if (truncateWal) {
            deleted += this.cctx.wal().truncate(null, this.firstCheckpointPointer());
        }
        chp.walFilesDeleted(deleted);
        return deletedCheckpoints;
    }

    private FileWALPointer newerPointer(WALPointer firstPointer, WALPointer secondPointer) {
        FileWALPointer first = (FileWALPointer)firstPointer;
        FileWALPointer second = (FileWALPointer)secondPointer;
        if (firstPointer == null) {
            return second;
        }
        if (secondPointer == null) {
            return first;
        }
        return first.index() > second.index() ? first : second;
    }

    private WALPointer checkpointMarkUntilDeleteByMemorySize() {
        if (this.histMap.size() <= this.maxCpHistMemSize) {
            return null;
        }
        int calculatedCpHistSize = this.maxCpHistMemSize;
        for (Map.Entry entry : this.histMap.entrySet()) {
            if (this.histMap.size() > calculatedCpHistSize++) continue;
            return ((CheckpointEntry)entry.getValue()).checkpointMark();
        }
        return this.lastCheckpoint().checkpointMark();
    }

    @Nullable
    private WALPointer checkpointMarkUntilDeleteByArchiveSize() {
        long absFileIdxToDel = this.cctx.wal().maxArchivedSegmentToDelete();
        if (absFileIdxToDel < 0L) {
            return null;
        }
        long fileUntilDel = absFileIdxToDel + 1L;
        long checkpointFileIdx = this.absFileIdx(this.lastCheckpoint());
        for (CheckpointEntry cpEntry : this.histMap.values()) {
            long currFileIdx = this.absFileIdx(cpEntry);
            if (checkpointFileIdx > currFileIdx && fileUntilDel > currFileIdx) continue;
            return cpEntry.checkpointMark();
        }
        return this.lastCheckpoint().checkpointMark();
    }

    private long absFileIdx(CheckpointEntry pointer) {
        return ((FileWALPointer)pointer.checkpointMark()).index();
    }

    private IgniteBiTuple<Long, Long> calculateWalSegmentsCovered() {
        IgniteBiTuple<Long, Long> tup = new IgniteBiTuple<Long, Long>(-1L, -1L);
        Map.Entry<Long, CheckpointEntry> lastEntry = this.histMap.lastEntry();
        if (lastEntry == null) {
            return tup;
        }
        Map.Entry<Long, CheckpointEntry> previousEntry = this.histMap.lowerEntry(lastEntry.getKey());
        WALPointer lastWALPointer = lastEntry.getValue().checkpointMark();
        long lastIdx = 0L;
        long prevIdx = 0L;
        if (lastWALPointer instanceof FileWALPointer) {
            lastIdx = ((FileWALPointer)lastWALPointer).index();
            if (previousEntry != null) {
                prevIdx = ((FileWALPointer)previousEntry.getValue().checkpointMark()).index();
            }
        }
        tup.set1(prevIdx);
        tup.set2(lastIdx - 1L);
        return tup;
    }

    @Nullable
    public WALPointer searchPartitionCounter(int grpId, int part, long partCntrSince) {
        CheckpointEntry entry = this.searchCheckpointEntry(grpId, part, partCntrSince);
        if (entry == null) {
            return null;
        }
        return entry.checkpointMark();
    }

    @Nullable
    public CheckpointEntry searchCheckpointEntry(int grpId, int part, long partCntrSince) {
        for (Long cpTs : this.checkpoints(true)) {
            try {
                CheckpointEntry entry = this.entry(cpTs);
                Long foundCntr = entry.partitionCounter(this.cctx, grpId, part);
                if (foundCntr == null || foundCntr > partCntrSince) continue;
                return entry;
            }
            catch (IgniteCheckedException ignore) {
                break;
            }
        }
        return null;
    }

    public Map<Integer, Map<Integer, CheckpointEntry>> searchAndReserveCheckpoints(Map<Integer, Set<Integer>> groupsAndPartitions) {
        if (F.isEmpty(groupsAndPartitions)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Map<Integer, CheckpointEntry>> res = new HashMap<Integer, Map<Integer, CheckpointEntry>>();
        CheckpointEntry prevReserved = null;
        for (Long cpTs : this.checkpoints(true)) {
            CheckpointEntry chpEntry = null;
            try {
                chpEntry = this.entry(cpTs);
                boolean reserved = this.cctx.wal().reserve(chpEntry.checkpointMark());
                if (!reserved) break;
                for (Integer n : new HashSet<Integer>(groupsAndPartitions.keySet())) {
                    if (this.isCheckpointApplicableForGroup(n, chpEntry)) continue;
                    groupsAndPartitions.remove(n);
                }
                for (Map.Entry entry : chpEntry.groupState(this.cctx).entrySet()) {
                    int grpId = (Integer)entry.getKey();
                    CheckpointEntry.GroupState cpGrpState = (CheckpointEntry.GroupState)entry.getValue();
                    Set<Integer> applicablePartitions = groupsAndPartitions.get(grpId);
                    if (F.isEmpty(applicablePartitions)) continue;
                    HashSet<Integer> inapplicablePartitions = null;
                    for (Integer partId : applicablePartitions) {
                        int pIdx = cpGrpState.indexByPartition(partId);
                        if (pIdx >= 0) {
                            res.computeIfAbsent(grpId, k -> new HashMap()).put(partId, chpEntry);
                            continue;
                        }
                        if (inapplicablePartitions == null) {
                            inapplicablePartitions = new HashSet<Integer>();
                        }
                        inapplicablePartitions.add(partId);
                    }
                    if (F.isEmpty(inapplicablePartitions)) continue;
                    for (Integer partId : inapplicablePartitions) {
                        applicablePartitions.remove(partId);
                    }
                }
                for (Map.Entry entry : new HashSet<Map.Entry<Integer, Set<Integer>>>(groupsAndPartitions.entrySet())) {
                    if (!((Set)entry.getValue()).isEmpty()) continue;
                    groupsAndPartitions.remove(entry.getKey());
                }
                if (groupsAndPartitions.isEmpty()) {
                    this.cctx.wal().release(chpEntry.checkpointMark());
                    break;
                }
                if (prevReserved != null) {
                    this.cctx.wal().release(prevReserved.checkpointMark());
                }
                prevReserved = chpEntry;
            }
            catch (IgniteCheckedException ex) {
                U.error(this.log, "Failed to process checkpoint: " + (chpEntry != null ? chpEntry : "none"), ex);
            }
        }
        return res;
    }

    private boolean isCheckpointApplicableForGroup(int grpId, CheckpointEntry cp) throws IgniteCheckedException {
        GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)this.cctx.database();
        if (dbMgr.isCheckpointInapplicableForWalRebalance(cp.timestamp(), grpId)) {
            return false;
        }
        return cp.groupState(this.cctx).containsKey(grpId);
    }
}

