/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.apache.ignite.lang.IgniteCallable;

public class FetchActiveTxOwnerTraceClosure
implements IgniteCallable<String> {
    private static final long serialVersionUID = 0L;
    private static final StackTraceElement[] STACK_TRACE_ELEMENT_EMPTY = new StackTraceElement[0];
    private final long txOwnerThreadId;

    public FetchActiveTxOwnerTraceClosure(long txOwnerThreadId) {
        this.txOwnerThreadId = txOwnerThreadId;
    }

    @Override
    public String call() throws Exception {
        StringBuilder traceDump = new StringBuilder("Stack trace of the transaction owner thread:\n");
        for (StackTraceElement stackTraceElement : this.getStackTrace()) {
            traceDump.append(stackTraceElement.toString());
            traceDump.append("\n");
        }
        return traceDump.toString();
    }

    private StackTraceElement[] getStackTrace() {
        ThreadInfo threadInfo;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        try {
            threadInfo = threadMXBean.getThreadInfo(this.txOwnerThreadId, Integer.MAX_VALUE);
        }
        catch (IllegalArgumentException | SecurityException ignored) {
            threadInfo = null;
        }
        return threadInfo == null ? STACK_TRACE_ELEMENT_EMPTY : threadInfo.getStackTrace();
    }
}

