/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class DataPageUpdateRecord
extends PageDeltaRecord {
    private int itemId;
    private byte[] payload;

    public DataPageUpdateRecord(int grpId, long pageId, int itemId, byte[] payload) {
        super(grpId, pageId);
        this.payload = payload;
        this.itemId = itemId;
    }

    public int itemId() {
        return this.itemId;
    }

    public byte[] payload() {
        return this.payload;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        assert (this.payload != null);
        AbstractDataPageIO io = (AbstractDataPageIO)PageIO.getPageIO(pageAddr);
        io.updateRow(pageAddr, this.itemId, pageMem.realPageSize(this.groupId()), this.payload, null, 0);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.DATA_PAGE_UPDATE_RECORD;
    }

    @Override
    public String toString() {
        return S.toString(DataPageUpdateRecord.class, this, "super", super.toString());
    }
}

