/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.ClusterLocalNodeMetricsMXBeanImpl;
import org.apache.ignite.internal.ClusterMetricsMXBeanImpl;
import org.apache.ignite.internal.GridKernalContextImpl;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.StripedExecutorMXBeanAdapter;
import org.apache.ignite.internal.ThreadPoolMXBeanAdapter;
import org.apache.ignite.internal.TransactionMetricsMxBeanImpl;
import org.apache.ignite.internal.TransactionsMXBeanImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMXBeanImpl;
import org.apache.ignite.internal.processors.cluster.BaselineAutoAdjustMXBeanImpl;
import org.apache.ignite.internal.processors.metric.MetricsMxBeanImpl;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.worker.FailureHandlingMxBeanImpl;
import org.apache.ignite.internal.worker.WorkersControlMXBeanImpl;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.mxbean.BaselineAutoAdjustMXBean;
import org.apache.ignite.mxbean.ClusterMetricsMXBean;
import org.apache.ignite.mxbean.DataStorageMXBean;
import org.apache.ignite.mxbean.FailureHandlingMxBean;
import org.apache.ignite.mxbean.IgniteMXBean;
import org.apache.ignite.mxbean.MetricsMxBean;
import org.apache.ignite.mxbean.StripedExecutorMXBean;
import org.apache.ignite.mxbean.ThreadPoolMXBean;
import org.apache.ignite.mxbean.TransactionMetricsMxBean;
import org.apache.ignite.mxbean.TransactionsMXBean;
import org.apache.ignite.mxbean.WorkersControlMXBean;
import org.apache.ignite.thread.IgniteStripedThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class IgniteMBeansManager {
    private final IgniteKernal kernal;
    private final GridKernalContextImpl ctx;
    private final IgniteLogger log;
    private final Set<ObjectName> mBeanNames = new HashSet<ObjectName>();

    public IgniteMBeansManager(IgniteKernal kernal) {
        this.kernal = kernal;
        this.ctx = (GridKernalContextImpl)kernal.context();
        this.log = this.ctx.log(IgniteMBeansManager.class);
    }

    public void registerAllMBeans(ExecutorService utilityCachePool, ExecutorService execSvc, ExecutorService svcExecSvc, ExecutorService sysExecSvc, StripedExecutor stripedExecSvc, ExecutorService p2pExecSvc, ExecutorService mgmtExecSvc, ExecutorService igfsExecSvc, StripedExecutor dataStreamExecSvc, ExecutorService restExecSvc, ExecutorService affExecSvc, @Nullable ExecutorService idxExecSvc, IgniteStripedThreadPoolExecutor callbackExecSvc, ExecutorService qryExecSvc, ExecutorService schemaExecSvc, ExecutorService rebalanceExecSvc, IgniteStripedThreadPoolExecutor rebalanceStripedExecSvc, @Nullable Map<String, ? extends ExecutorService> customExecSvcs, WorkersRegistry workersRegistry) throws IgniteCheckedException {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        this.registerMBean("Kernal", IgniteKernal.class.getSimpleName(), this.kernal, IgniteMXBean.class);
        ClusterLocalNodeMetricsMXBeanImpl locMetricsBean = new ClusterLocalNodeMetricsMXBeanImpl(this.ctx.discovery());
        this.registerMBean("Kernal", locMetricsBean.getClass().getSimpleName(), locMetricsBean, ClusterMetricsMXBean.class);
        ClusterMetricsMXBeanImpl metricsBean = new ClusterMetricsMXBeanImpl(this.kernal.cluster());
        this.registerMBean("Kernal", metricsBean.getClass().getSimpleName(), metricsBean, ClusterMetricsMXBean.class);
        TransactionMetricsMxBeanImpl txMetricsMXBean = new TransactionMetricsMxBeanImpl(this.ctx.cache().transactions().metrics());
        this.registerMBean("TransactionMetrics", txMetricsMXBean.getClass().getSimpleName(), txMetricsMXBean, TransactionMetricsMxBean.class);
        TransactionsMXBeanImpl txMXBean = new TransactionsMXBeanImpl(this.ctx);
        this.registerMBean("Transactions", txMXBean.getClass().getSimpleName(), txMXBean, TransactionsMXBean.class);
        DataStorageMXBeanImpl dataStorageMXBean = new DataStorageMXBeanImpl(this.ctx);
        this.registerMBean("DataStorage", dataStorageMXBean.getClass().getSimpleName(), dataStorageMXBean, DataStorageMXBean.class);
        BaselineAutoAdjustMXBeanImpl baselineAutoAdjustMXBean = new BaselineAutoAdjustMXBeanImpl(this.ctx);
        this.registerMBean("Baseline", baselineAutoAdjustMXBean.getClass().getSimpleName(), baselineAutoAdjustMXBean, BaselineAutoAdjustMXBean.class);
        MetricsMxBeanImpl metricsMxBean = new MetricsMxBeanImpl(this.ctx.metric(), this.log);
        this.registerMBean("Metrics", metricsMxBean.getClass().getSimpleName(), metricsMxBean, MetricsMxBean.class);
        this.registerExecutorMBean("GridUtilityCacheExecutor", utilityCachePool);
        this.registerExecutorMBean("GridExecutionExecutor", execSvc);
        this.registerExecutorMBean("GridServicesExecutor", svcExecSvc);
        this.registerExecutorMBean("GridSystemExecutor", sysExecSvc);
        this.registerExecutorMBean("GridClassLoadingExecutor", p2pExecSvc);
        this.registerExecutorMBean("GridManagementExecutor", mgmtExecSvc);
        this.registerExecutorMBean("GridIgfsExecutor", igfsExecSvc);
        this.registerExecutorMBean("GridDataStreamExecutor", dataStreamExecSvc);
        this.registerExecutorMBean("GridAffinityExecutor", affExecSvc);
        this.registerExecutorMBean("GridCallbackExecutor", callbackExecSvc);
        this.registerExecutorMBean("GridQueryExecutor", qryExecSvc);
        this.registerExecutorMBean("GridSchemaExecutor", schemaExecSvc);
        this.registerExecutorMBean("GridRebalanceExecutor", rebalanceExecSvc);
        this.registerExecutorMBean("GridRebalanceStripedExecutor", rebalanceStripedExecSvc);
        if (idxExecSvc != null) {
            this.registerExecutorMBean("GridIndexingExecutor", idxExecSvc);
        }
        if (this.ctx.config().getConnectorConfiguration() != null) {
            this.registerExecutorMBean("GridRestExecutor", restExecSvc);
        }
        if (stripedExecSvc != null) {
            this.registerMBean("Thread Pools", "StripedExecutor", new StripedExecutorMXBeanAdapter(stripedExecSvc), StripedExecutorMXBean.class);
        }
        if (customExecSvcs != null) {
            for (Map.Entry<String, ? extends ExecutorService> entry : customExecSvcs.entrySet()) {
                this.registerExecutorMBean(entry.getKey(), entry.getValue());
            }
        }
        if (U.IGNITE_TEST_FEATURES_ENABLED) {
            WorkersControlMXBeanImpl workerCtrlMXBean = new WorkersControlMXBeanImpl(workersRegistry);
            this.registerMBean("Kernal", workerCtrlMXBean.getClass().getSimpleName(), workerCtrlMXBean, WorkersControlMXBean.class);
        }
        FailureHandlingMxBeanImpl blockOpCtrlMXBean = new FailureHandlingMxBeanImpl(workersRegistry, this.ctx.cache().context().database());
        this.registerMBean("Kernal", blockOpCtrlMXBean.getClass().getSimpleName(), blockOpCtrlMXBean, FailureHandlingMxBean.class);
        if (this.ctx.query().moduleEnabled()) {
            this.ctx.query().getIndexing().registerMxBeans(this);
        }
    }

    private void registerExecutorMBean(String name, ExecutorService exec) throws IgniteCheckedException {
        this.registerMBean("Thread Pools", name, new ThreadPoolMXBeanAdapter(exec), ThreadPoolMXBean.class);
    }

    public <T> void registerMBean(String grp, String name, T impl2, Class<T> itf) throws IgniteCheckedException {
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            ObjectName objName = U.registerMBean(this.ctx.config().getMBeanServer(), this.ctx.config().getIgniteInstanceName(), grp, name, impl2, itf);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registered MBean: " + objName);
            }
            this.mBeanNames.add(objName);
        }
        catch (JMException e) {
            throw new IgniteCheckedException("Failed to register MBean " + name, e);
        }
    }

    public boolean unregisterAllMBeans() {
        boolean success = true;
        for (ObjectName name : this.mBeanNames) {
            success = success && this.unregisterMBean(name);
        }
        return success;
    }

    private boolean unregisterMBean(ObjectName mbean) {
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            this.ctx.config().getMBeanServer().unregisterMBean(mbean);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered MBean: " + mbean);
            }
            return true;
        }
        catch (JMException e) {
            U.error(this.log, "Failed to unregister MBean.", e);
            return false;
        }
    }
}

