/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.argument.CommandArg;
import org.apache.ignite.internal.commandline.cache.CacheContention;
import org.apache.ignite.internal.commandline.cache.CacheDistribution;
import org.apache.ignite.internal.commandline.cache.CacheValidateIndexes;
import org.apache.ignite.internal.commandline.cache.CacheViewer;
import org.apache.ignite.internal.commandline.cache.FindAndDeleteGarbage;
import org.apache.ignite.internal.commandline.cache.IdleVerify;
import org.apache.ignite.internal.commandline.cache.ResetLostPartitions;
import org.apache.ignite.internal.commandline.cache.argument.DistributionCommandArg;
import org.apache.ignite.internal.commandline.cache.argument.FindAndDeleteGarbageArg;
import org.apache.ignite.internal.commandline.cache.argument.IdleVerifyCommandArg;
import org.apache.ignite.internal.commandline.cache.argument.ListCommandArg;
import org.apache.ignite.internal.commandline.cache.argument.ValidateIndexesCommandArg;
import org.jetbrains.annotations.Nullable;

public enum CacheSubcommands {
    HELP("help", null, null),
    IDLE_VERIFY("idle_verify", IdleVerifyCommandArg.class, new IdleVerify()),
    LIST("list", ListCommandArg.class, new CacheViewer()),
    VALIDATE_INDEXES("validate_indexes", ValidateIndexesCommandArg.class, new CacheValidateIndexes()),
    CONTENTION("contention", null, new CacheContention()),
    DISTRIBUTION("distribution", DistributionCommandArg.class, new CacheDistribution()),
    RESET_LOST_PARTITIONS("reset_lost_partitions", null, new ResetLostPartitions()),
    FIND_AND_DELETE_GARBAGE("find_garbage", FindAndDeleteGarbageArg.class, new FindAndDeleteGarbage());

    private static final CacheSubcommands[] VALS;
    private final Class<? extends Enum<? extends CommandArg>> commandArgs;
    private final String name;
    private final Command command;

    private CacheSubcommands(String name, Class<? extends Enum<? extends CommandArg>> commandArgs, Command command) {
        this.name = name;
        this.commandArgs = commandArgs;
        this.command = command;
    }

    public static CacheSubcommands of(String text) {
        for (CacheSubcommands cmd : CacheSubcommands.values()) {
            if (!cmd.text().equalsIgnoreCase(text)) continue;
            return cmd;
        }
        return null;
    }

    public String text() {
        return this.name;
    }

    public Command subcommand() {
        return this.command;
    }

    public Class<? extends Enum<? extends CommandArg>> getCommandArgs() {
        return this.commandArgs;
    }

    @Nullable
    public static CacheSubcommands fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    public String toString() {
        return this.name;
    }

    static {
        VALS = CacheSubcommands.values();
    }
}

