/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.BufferHolder;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeWriter;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.bitset.BitSetMethods;

public final class UnsafeRowWriter
extends UnsafeWriter {
    private final UnsafeRow row;
    private final int nullBitsSize;
    private final int fixedSize;

    public UnsafeRowWriter(int numFields) {
        this(new UnsafeRow(numFields));
    }

    public UnsafeRowWriter(int numFields, int initialBufferSize) {
        this(new UnsafeRow(numFields), initialBufferSize);
    }

    public UnsafeRowWriter(UnsafeWriter writer, int numFields) {
        this(null, writer.getBufferHolder(), numFields);
    }

    private UnsafeRowWriter(UnsafeRow row) {
        this(row, new BufferHolder(row), row.numFields());
    }

    private UnsafeRowWriter(UnsafeRow row, int initialBufferSize) {
        this(row, new BufferHolder(row, initialBufferSize), row.numFields());
    }

    private UnsafeRowWriter(UnsafeRow row, BufferHolder holder, int numFields) {
        super(holder);
        this.row = row;
        this.nullBitsSize = UnsafeRow.calculateBitSetWidthInBytes(numFields);
        this.fixedSize = this.nullBitsSize + 8 * numFields;
        this.startingOffset = this.cursor();
    }

    public UnsafeRow getRow() {
        this.row.setTotalSize(this.totalSize());
        return this.row;
    }

    public void resetRowWriter() {
        this.startingOffset = this.cursor();
        this.grow(this.fixedSize);
        this.increaseCursor(this.fixedSize);
        this.zeroOutNullBytes();
    }

    public void zeroOutNullBytes() {
        for (int i = 0; i < this.nullBitsSize; i += 8) {
            Platform.putLong((Object)this.getBuffer(), (long)(this.startingOffset + i), (long)0L);
        }
    }

    public boolean isNullAt(int ordinal) {
        return BitSetMethods.isSet((Object)this.getBuffer(), (long)this.startingOffset, (int)ordinal);
    }

    public void setNullAt(int ordinal) {
        BitSetMethods.set((Object)this.getBuffer(), (long)this.startingOffset, (int)ordinal);
        this.write(ordinal, 0L);
    }

    @Override
    public void setNull1Bytes(int ordinal) {
        this.setNullAt(ordinal);
    }

    @Override
    public void setNull2Bytes(int ordinal) {
        this.setNullAt(ordinal);
    }

    @Override
    public void setNull4Bytes(int ordinal) {
        this.setNullAt(ordinal);
    }

    @Override
    public void setNull8Bytes(int ordinal) {
        this.setNullAt(ordinal);
    }

    public long getFieldOffset(int ordinal) {
        return this.startingOffset + this.nullBitsSize + 8 * ordinal;
    }

    @Override
    public void write(int ordinal, boolean value2) {
        long offset = this.getFieldOffset(ordinal);
        this.writeLong(offset, 0L);
        this.writeBoolean(offset, value2);
    }

    @Override
    public void write(int ordinal, byte value2) {
        long offset = this.getFieldOffset(ordinal);
        this.writeLong(offset, 0L);
        this.writeByte(offset, value2);
    }

    @Override
    public void write(int ordinal, short value2) {
        long offset = this.getFieldOffset(ordinal);
        this.writeLong(offset, 0L);
        this.writeShort(offset, value2);
    }

    @Override
    public void write(int ordinal, int value2) {
        long offset = this.getFieldOffset(ordinal);
        this.writeLong(offset, 0L);
        this.writeInt(offset, value2);
    }

    @Override
    public void write(int ordinal, long value2) {
        this.writeLong(this.getFieldOffset(ordinal), value2);
    }

    @Override
    public void write(int ordinal, float value2) {
        long offset = this.getFieldOffset(ordinal);
        this.writeLong(offset, 0L);
        this.writeFloat(offset, value2);
    }

    @Override
    public void write(int ordinal, double value2) {
        this.writeDouble(this.getFieldOffset(ordinal), value2);
    }

    @Override
    public void write(int ordinal, Decimal input, int precision, int scale) {
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            if (input != null && input.changePrecision(precision, scale)) {
                this.write(ordinal, input.toUnscaledLong());
            } else {
                this.setNullAt(ordinal);
            }
        } else {
            this.holder.grow(16);
            Platform.putLong((Object)this.getBuffer(), (long)this.cursor(), (long)0L);
            Platform.putLong((Object)this.getBuffer(), (long)(this.cursor() + 8), (long)0L);
            if (input == null || !input.changePrecision(precision, scale)) {
                BitSetMethods.set((Object)this.getBuffer(), (long)this.startingOffset, (int)ordinal);
                this.setOffsetAndSize(ordinal, 0);
            } else {
                byte[] bytes = input.toJavaBigDecimal().unscaledValue().toByteArray();
                int numBytes = bytes.length;
                assert (numBytes <= 16);
                Platform.copyMemory((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (Object)this.getBuffer(), (long)this.cursor(), (long)numBytes);
                this.setOffsetAndSize(ordinal, bytes.length);
            }
            this.increaseCursor(16);
        }
    }
}

