/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Sequence$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$class;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.Mirrors;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(start, stop, step) - Generates an array of elements from start to stop (inclusive),\n      incrementing by step. The type of the returned elements is the same as the type of argument\n      expressions.\n\n      Supported types are: byte, short, integer, long, date, timestamp.\n\n      The start and stop expressions must resolve to the same type.\n      If start and stop expressions resolve to the 'date' or 'timestamp' type\n      then the step expression must resolve to the 'interval' type, otherwise to the same type\n      as the start and stop expressions.\n  ", arguments="\n    Arguments:\n      * start - an expression. The start of the range.\n      * stop - an expression. The end the range (inclusive).\n      * step - an optional expression. The step of the range.\n          By default step is 1 if start is less than or equal to stop, otherwise -1.\n          For the temporal sequences it's 1 day and -1 day respectively.\n          If start is greater than stop then the step must be negative, and vice versa.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 5);\n       [1,2,3,4,5]\n      > SELECT _FUNC_(5, 1);\n       [5,4,3,2,1]\n      > SELECT _FUNC_(to_date('2018-01-01'), to_date('2018-03-01'), interval 1 month);\n       [2018-01-01,2018-02-01,2018-03-01]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\r=h\u0001B\u0001\u0003\u0001>\u0011\u0001bU3rk\u0016t7-\u001a\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000b\u0018;A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"AA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t9\u0001K]8ek\u000e$\bC\u0001\r\u001f\u0013\ty\u0012D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\"\u0001\tU\r\u0011\"\u0001#\u0003\u0015\u0019H/\u0019:u+\u0005\u0001\u0002\u0002\u0003\u0013\u0001\u0005#\u0005\u000b\u0011\u0002\t\u0002\rM$\u0018M\u001d;!\u0011!1\u0003A!f\u0001\n\u0003\u0011\u0013\u0001B:u_BD\u0001\u0002\u000b\u0001\u0003\u0012\u0003\u0006I\u0001E\u0001\u0006gR|\u0007\u000f\t\u0005\tU\u0001\u0011)\u001a!C\u0001W\u000591\u000f^3q\u001fB$X#\u0001\u0017\u0011\u0007ai\u0003#\u0003\u0002/3\t1q\n\u001d;j_:D\u0001\u0002\r\u0001\u0003\u0012\u0003\u0006I\u0001L\u0001\tgR,\u0007o\u00149uA!A!\u0007\u0001BK\u0002\u0013\u00051'\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012\u0001\u000e\t\u000415*\u0004C\u0001\u001c:\u001d\tAr'\u0003\u000293\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tA\u0014\u0004\u0003\u0005>\u0001\tE\t\u0015!\u00035\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\t\u000b}\u0002A\u0011\u0001!\u0002\rqJg.\u001b;?)\u0015\t%i\u0011#F!\t\t\u0002\u0001C\u0003\"}\u0001\u0007\u0001\u0003C\u0003'}\u0001\u0007\u0001\u0003C\u0003+}\u0001\u0007A\u0006C\u00043}A\u0005\t\u0019\u0001\u001b\t\u000b}\u0002A\u0011A$\u0015\u0007\u0005C\u0015\nC\u0003\"\r\u0002\u0007\u0001\u0003C\u0003'\r\u0002\u0007\u0001\u0003C\u0003@\u0001\u0011\u00051\n\u0006\u0003B\u00196s\u0005\"B\u0011K\u0001\u0004\u0001\u0002\"\u0002\u0014K\u0001\u0004\u0001\u0002\"B(K\u0001\u0004\u0001\u0012\u0001B:uKBDQ!\u0015\u0001\u0005BI\u000bAb^5uQRKW.\u001a.p]\u0016$\"\u0001F*\t\u000bI\u0002\u0006\u0019A\u001b\t\u000bU\u0003A\u0011\t,\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012a\u0016\t\u00041\u0002\u0004bBA-_\u001d\tQV,D\u0001\\\u0015\taf\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011q,G\u0001\ba\u0006\u001c7.Y4f\u0013\t\t'MA\u0002TKFT!aX\r\t\u000b\u0011\u0004A\u0011I3\u0002\u0011\u0019|G\u000eZ1cY\u0016,\u0012A\u001a\t\u00031\u001dL!\u0001[\r\u0003\u000f\t{w\u000e\\3b]\")!\u000e\u0001C!K\u0006Aa.\u001e7mC\ndW\rC\u0003m\u0001\u0011\u0005S.\u0001\u0005eCR\fG+\u001f9f+\u0005q\u0007CA8s\u001b\u0005\u0001(BA9\u0007\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\bOA\u0005BeJ\f\u0017\u0010V=qK\")Q\u000f\u0001C!m\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\tq\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{\t\u0005A\u0011M\\1msNL7/\u0003\u0002}s\nyA+\u001f9f\u0007\",7m\u001b*fgVdG\u000fC\u0003\u007f\u0001\u0011\u0005a+A\td_\u0016\u00148-\u001b2mK\u000eC\u0017\u000e\u001c3sK:Dq!!\u0001\u0001\t\u0003\t\u0019!\u0001\bdCN$8\t[5mIJ,g\u000eV8\u0015\u0007A\t)\u0001C\u0004\u0002\b}\u0004\r!!\u0003\u0002\u0013]LG-\u001a:UsB,\u0007cA8\u0002\f%\u0019\u0011Q\u00029\u0003\u0011\u0011\u000bG/\u0019+za\u0016D!\"!\u0005\u0001\u0011\u000b\u0007I\u0011BA\n\u0003\u0011IW\u000e\u001d7\u0016\u0005\u0005U\u0001\u0003BA\f\u0003/s1!EA\r\u000f\u001d\tYB\u0001E\u0001\u0003;\t\u0001bU3rk\u0016t7-\u001a\t\u0004#\u0005}aAB\u0001\u0003\u0011\u0003\t\tcE\u0003\u0002 \u0005\rR\u0004E\u0002\u0019\u0003KI1!a\n\u001a\u0005\u0019\te.\u001f*fM\"9q(a\b\u0005\u0002\u0005-BCAA\u000f\u000b\u001d\ty#a\b\u0005\u0003c\u0011\u0011\u0003T3tgRC\u0017M\\(s\u000bF,\u0018\r\u001c$o!!A\u00121GA\u001c\u0003o1\u0017bAA\u001b3\tIa)\u001e8di&|gN\r\t\u00041\u0005e\u0012bAA\u001e3\t\u0019\u0011I\\=\u0007\u000f\u0005}\u0012q\u0004\u0003\u0002B\tYA)\u001a4bk2$8\u000b^3q'\u0011\ti$a\t\t\u0017\u0005\u0015\u0013Q\bB\u0001B\u0003%\u0011qI\u0001\u0005YR,\u0017\u000f\u0005\u0003\u0002J\u00055RBAA\u0010\u0011-\ti%!\u0010\u0003\u0002\u0003\u0006I!!\u0003\u0002\u0011M$X\r\u001d+za\u0016D1\"!\u0015\u0002>\t\u0005\t\u0015!\u0003\u00028\u0005\u0019qN\\3\t\u000f}\ni\u0004\"\u0001\u0002VQA\u0011qKA-\u00037\ni\u0006\u0005\u0003\u0002J\u0005u\u0002\u0002CA#\u0003'\u0002\r!a\u0012\t\u0011\u00055\u00131\u000ba\u0001\u0003\u0013A\u0001\"!\u0015\u0002T\u0001\u0007\u0011q\u0007\u0005\u000b\u0003C\niD1A\u0005\n\u0005\r\u0014a\u00038fO\u0006$\u0018N^3P]\u0016,\"!a\u000e\t\u0013\u0005\u001d\u0014Q\bQ\u0001\n\u0005]\u0012\u0001\u00048fO\u0006$\u0018N^3P]\u0016\u0004\u0003\u0002CA6\u0003{!\t!!\u001c\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005]\u0012qNA9\u0011\u001d\t\u0013\u0011\u000ea\u0001\u0003oAqAJA5\u0001\u0004\t9\u0004\u0003\u0005\u0002v\u0005uB\u0011AA<\u0003\u001d9WM\\\"pI\u0016$\u0002\"!\u001f\u0002\u0006\u0006=\u00151\u0013\t\u0005\u0003w\n\t)\u0004\u0002\u0002~)\u0019\u0011q\u0010\u0002\u0002\u000f\r|G-Z4f]&!\u00111QA?\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\u0002CAD\u0003g\u0002\r!!#\u0002\u0007\r$\b\u0010\u0005\u0003\u0002|\u0005-\u0015\u0002BAG\u0003{\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0005\u0002\u0012\u0006M\u0004\u0019AA=\u0003!\u0019H/\u0019:u\u000f\u0016t\u0007\u0002CAK\u0003g\u0002\r!!\u001f\u0002\u000fM$x\u000e]$f]\u001aQ\u0011\u0011TA\u0010!\u0003\rJ!a'\u0003\u0019M+\u0017/^3oG\u0016LU\u000e\u001d7\u0014\t\u0005]\u00151\u0005\u0005\t\u0003?\u000b9J\"\u0001\u0002\"\u0006!QM^1m)!\t9$a)\u0002&\u0006\u001d\u0006bB\u0011\u0002\u001e\u0002\u0007\u0011q\u0007\u0005\bM\u0005u\u0005\u0019AA\u001c\u0011\u001dy\u0015Q\u0014a\u0001\u0003oA\u0001\"!\u001e\u0002\u0018\u001a\u0005\u00111\u0016\u000b\u000ek\u00055\u0016qVAY\u0003g\u000b),!/\t\u0011\u0005\u001d\u0015\u0011\u0016a\u0001\u0003\u0013Ca!IAU\u0001\u0004)\u0004B\u0002\u0014\u0002*\u0002\u0007Q\u0007\u0003\u0004P\u0003S\u0003\r!\u000e\u0005\b\u0003o\u000bI\u000b1\u00016\u0003\r\t'O\u001d\u0005\b\u0003w\u000bI\u000b1\u00016\u0003!)G.Z7UsB,\u0007BCA`\u0003/\u0013\rQ\"\u0001\u0002B\u0006YA-\u001a4bk2$8\u000b^3q+\t\t9FB\u0004\u0002F\u0006}A!a2\u0003)%sG/Z4sC2\u001cV-];f]\u000e,\u0017*\u001c9m+\u0011\tI-!;\u0014\r\u0005\r\u00171EAf!\u0011\tI%a&\t\u0017\u0005m\u00161\u0019B\u0001B\u0003%\u0011q\u001a\t\u0004_\u0006E\u0017bAAja\na\u0011J\u001c;fOJ\fG\u000eV=qK\"Y\u0011q[Ab\u0005\u0007\u0005\u000b1BAm\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u00037\f\t/!:\u000e\u0005\u0005u'bAAp3\u00059!/\u001a4mK\u000e$\u0018\u0002BAr\u0003;\u0014\u0001b\u00117bgN$\u0016m\u001a\t\u0005\u0003O\fI\u000f\u0004\u0001\u0005\u0011\u0005-\u00181\u0019b\u0001\u0003[\u0014\u0011\u0001V\t\u0005\u0003_\f9\u0004E\u0002\u0019\u0003cL1!a=\u001a\u0005\u001dqu\u000e\u001e5j]\u001eD1\"a>\u0002D\n\u0005\t\u0015a\u0003\u0002z\u0006\u0019a.^7\u0011\u000ba\u000bY0!:\n\u0007\u0005u(M\u0001\u0005J]R,wM]1m\u0011\u001dy\u00141\u0019C\u0001\u0005\u0003!BAa\u0001\u0003\fQ1!Q\u0001B\u0004\u0005\u0013\u0001b!!\u0013\u0002D\u0006\u0015\b\u0002CAl\u0003\u007f\u0004\u001d!!7\t\u0011\u0005]\u0018q a\u0002\u0003sD\u0001\"a/\u0002\u0000\u0002\u0007\u0011q\u001a\u0005\u000b\u0003\u007f\u000b\u0019M1A\u0005B\u0005\u0005\u0007\"\u0003B\t\u0003\u0007\u0004\u000b\u0011BA,\u00031!WMZ1vYR\u001cF/\u001a9!\u0011!\ty*a1\u0005B\tUA\u0003\u0003B\f\u0005;\u0011\tC!\n\u0011\u000ba\u0011I\"!:\n\u0007\tm\u0011DA\u0003BeJ\f\u0017\u0010\u0003\u0005\u0003 \tM\u0001\u0019AA\u001c\u0003\u0019Ig\u000e];uc!A!1\u0005B\n\u0001\u0004\t9$\u0001\u0004j]B,HO\r\u0005\t\u0005O\u0011\u0019\u00021\u0001\u00028\u00051\u0011N\u001c9viNB\u0001\"!\u001e\u0002D\u0012\u0005#1\u0006\u000b\u000ek\t5\"q\u0006B\u0019\u0005g\u0011)Da\u000e\t\u0011\u0005\u001d%\u0011\u0006a\u0001\u0003\u0013Ca!\tB\u0015\u0001\u0004)\u0004B\u0002\u0014\u0003*\u0001\u0007Q\u0007\u0003\u0004P\u0005S\u0001\r!\u000e\u0005\b\u0003o\u0013I\u00031\u00016\u0011\u001d\tYL!\u000bA\u0002U2qAa\u000f\u0002 \u0011\u0011iD\u0001\u000bUK6\u0004xN]1m'\u0016\fX/\u001a8dK&k\u0007\u000f\\\u000b\u0005\u0005\u007f\u0011Yf\u0005\u0004\u0003:\u0005\r\u00121\u001a\u0005\f\u0005\u0007\u0012ID!A!\u0002\u0013\ty-\u0001\u0002ei\"Y!q\tB\u001d\u0005\u0003\u0005\u000b\u0011\u0002B%\u0003\u0015\u00198-\u00197f!\rA\"1J\u0005\u0004\u0005\u001bJ\"\u0001\u0002'p]\u001eD1B!\u0015\u0003:\t\u0005\t\u0015!\u0003\u0003T\u0005AaM]8n\u0019>tw\rE\u0004\u0019\u0005+\u0012IE!\u0017\n\u0007\t]\u0013DA\u0005Gk:\u001cG/[8ocA!\u0011q\u001dB.\t!\tYO!\u000fC\u0002\u00055\bb\u0003B0\u0005s\u0011\t\u0011)A\u0005\u0005C\n\u0001\u0002^5nKj{g.\u001a\t\u0005\u0005G\u0012i'\u0004\u0002\u0003f)!!q\rB5\u0003\u0011)H/\u001b7\u000b\u0005\t-\u0014\u0001\u00026bm\u0006LAAa\u001c\u0003f\tAA+[7f5>tW\rC\u0006\u0003t\te\"1!Q\u0001\f\tU\u0014AC3wS\u0012,gnY3%eA1\u00111\\Aq\u00053B1\"a>\u0003:\t\u0005\t\u0015a\u0003\u0003zA)\u0001,a?\u0003Z!9qH!\u000f\u0005\u0002\tuDC\u0003B@\u0005\u000f\u0013IIa#\u0003\u000eR1!\u0011\u0011BB\u0005\u000b\u0003b!!\u0013\u0003:\te\u0003\u0002\u0003B:\u0005w\u0002\u001dA!\u001e\t\u0011\u0005](1\u0010a\u0002\u0005sB\u0001Ba\u0011\u0003|\u0001\u0007\u0011q\u001a\u0005\t\u0005\u000f\u0012Y\b1\u0001\u0003J!A!\u0011\u000bB>\u0001\u0004\u0011\u0019\u0006\u0003\u0005\u0003`\tm\u0004\u0019\u0001B1\u0011)\tyL!\u000fC\u0002\u0013\u0005\u0013\u0011\u0019\u0005\n\u0005#\u0011I\u0004)A\u0005\u0003/B!B!&\u0003:\t\u0007I\u0011\u0002BL\u0003I\u0011\u0017mY6fIN+\u0017/^3oG\u0016LU\u000e\u001d7\u0016\u0005\te\u0005CBA%\u0003\u0007\u0014I\u0006C\u0005\u0003\u001e\ne\u0002\u0015!\u0003\u0003\u001a\u0006\u0019\"-Y2lK\u0012\u001cV-];f]\u000e,\u0017*\u001c9mA!Q!\u0011\u0015B\u001d\u0005\u0004%IAa)\u0002\u001d5L7M]8t!\u0016\u0014Xj\u001c8uQV\u0011!\u0011\n\u0005\n\u0005O\u0013I\u0004)A\u0005\u0005\u0013\nq\"\\5de>\u001c\b+\u001a:N_:$\b\u000e\t\u0005\t\u0003?\u0013I\u0004\"\u0011\u0003,RA!Q\u0016BX\u0005c\u0013\u0019\fE\u0003\u0019\u00053\u0011I\u0006\u0003\u0005\u0003 \t%\u0006\u0019AA\u001c\u0011!\u0011\u0019C!+A\u0002\u0005]\u0002\u0002\u0003B\u0014\u0005S\u0003\r!a\u000e\t\u0011\u0005U$\u0011\bC!\u0005o#R\"\u000eB]\u0005w\u0013iLa0\u0003B\n\r\u0007\u0002CAD\u0005k\u0003\r!!#\t\r\u0005\u0012)\f1\u00016\u0011\u00191#Q\u0017a\u0001k!1qJ!.A\u0002UBq!a.\u00036\u0002\u0007Q\u0007C\u0004\u0002<\nU\u0006\u0019A\u001b\t\u0011\t\u001d\u0017q\u0004C\u0005\u0005\u0013\f\u0011cZ3u'\u0016\fX/\u001a8dK2+gn\u001a;i+\u0011\u0011YMa7\u0015\u0011\t5'q\u001cBq\u0005G$BAa4\u0003VB\u0019\u0001D!5\n\u0007\tM\u0017DA\u0002J]RD\u0001\"a>\u0003F\u0002\u000f!q\u001b\t\u00061\u0006m(\u0011\u001c\t\u0005\u0003O\u0014Y\u000e\u0002\u0005\u0003^\n\u0015'\u0019AAw\u0005\u0005)\u0006bB\u0011\u0003F\u0002\u0007!\u0011\u001c\u0005\bM\t\u0015\u0007\u0019\u0001Bm\u0011\u001dy%Q\u0019a\u0001\u00053D\u0001Ba:\u0002 \u0011%!\u0011^\u0001\u0016O\u0016t7+Z9vK:\u001cW\rT3oORD7i\u001c3f)-)$1\u001eBw\u0005_\u0014\tPa=\t\u0011\u0005\u001d%Q\u001da\u0001\u0003\u0013Ca!\tBs\u0001\u0004)\u0004B\u0002\u0014\u0003f\u0002\u0007Q\u0007\u0003\u0004P\u0005K\u0004\r!\u000e\u0005\b\u0005k\u0014)\u000f1\u00016\u0003\raWM\u001c\u0005\u000b\u0003W\ny\"!A\u0005\u0002\neH#C!\u0003|\nu(q`B\u0001\u0011\u0019\t#q\u001fa\u0001!!1aEa>A\u0002AAaA\u000bB|\u0001\u0004a\u0003\u0002\u0003\u001a\u0003xB\u0005\t\u0019\u0001\u001b\t\u0015\r\u0015\u0011qDA\u0001\n\u0003\u001b9!A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r%1\u0011\u0003\t\u000515\u001aY\u0001E\u0004\u0019\u0007\u001b\u0001\u0002\u0003\f\u001b\n\u0007\r=\u0011D\u0001\u0004UkBdW\r\u000e\u0005\n\u0007'\u0019\u0019!!AA\u0002\u0005\u000b1\u0001\u001f\u00131\u0011)\u00199\"a\b\u0012\u0002\u0013\u00051\u0011D\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\rm!f\u0001\u001b\u0004\u001e-\u00121q\u0004\t\u0005\u0007C\u0019Y#\u0004\u0002\u0004$)!1QEB\u0014\u0003%)hn\u00195fG.,GMC\u0002\u0004*e\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0019ica\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u00042\u0005}\u0011\u0013!C\u0001\u00073\tq\"\u00199qYf$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0007k\ty\"!A\u0005\n\r]\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!\u000f\u0011\t\rm2\u0011I\u0007\u0003\u0007{QAaa\u0010\u0003j\u0005!A.\u00198h\u0013\u0011\u0019\u0019e!\u0010\u0003\r=\u0013'.Z2u\u0011)\u00199\u0005\u0001E\u0001B\u0003&\u0011QC\u0001\u0006S6\u0004H\u000e\t\u0015\u0005\u0007\u000b\u001aY\u0005E\u0002\u0019\u0007\u001bJ1aa\u0014\u001a\u0005%!(/\u00198tS\u0016tG\u000fC\u0004\u0002 \u0002!\tea\u0015\u0015\t\u0005]2Q\u000b\u0005\u000b\u0007/\u001a\t\u0006%AA\u0002\re\u0013!B5oaV$\b\u0003BB.\u0007;j\u0011\u0001B\u0005\u0004\u0007?\"!aC%oi\u0016\u0014h.\u00197S_^Dqaa\u0019\u0001\t#\u001a)'A\u0005e_\u001e+gnQ8eKR1\u0011\u0011PB4\u0007SB\u0001\"a\"\u0004b\u0001\u0007\u0011\u0011\u0012\u0005\t\u0007W\u001a\t\u00071\u0001\u0002z\u0005\u0011QM\u001e\u0005\n\u0007_\u0002\u0011\u0011!C\u0001\u0007c\nAaY8qsRI\u0011ia\u001d\u0004v\r]4\u0011\u0010\u0005\tC\r5\u0004\u0013!a\u0001!!Aae!\u001c\u0011\u0002\u0003\u0007\u0001\u0003\u0003\u0005+\u0007[\u0002\n\u00111\u0001-\u0011!\u00114Q\u000eI\u0001\u0002\u0004!\u0004\"CB?\u0001E\u0005I\u0011AB@\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!!+\u0007A\u0019i\u0002C\u0005\u0004\u0006\u0002\t\n\u0011\"\u0001\u0004\u0000\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CBE\u0001E\u0005I\u0011ABF\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"a!$+\u00071\u001ai\u0002C\u0005\u0004\u0012\u0002\t\n\u0011\"\u0001\u0004\u001a\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0004\"CBK\u0001\u0005\u0005I\u0011IBL\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111\u0011\u0014\t\u0005\u0007w\u0019Y*C\u0002;\u0007{A\u0011ba(\u0001\u0003\u0003%\ta!)\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t=\u0007\"CBS\u0001\u0005\u0005I\u0011ABT\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u000e\u0004*\"Q11VBR\u0003\u0003\u0005\rAa4\u0002\u0007a$\u0013\u0007C\u0005\u00040\u0002\t\t\u0011\"\u0011\u00042\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00044B11QWB^\u0003oi!aa.\u000b\u0007\re\u0016$\u0001\u0006d_2dWm\u0019;j_:LAa!0\u00048\nA\u0011\n^3sCR|'\u000fC\u0005\u0004B\u0002\t\t\u0011\"\u0001\u0004D\u0006A1-\u00198FcV\fG\u000eF\u0002g\u0007\u000bD!ba+\u0004@\u0006\u0005\t\u0019AA\u001c\u0011%\u0019I\rAA\u0001\n\u0003\u001aY-\u0001\u0004fcV\fGn\u001d\u000b\u0004M\u000e5\u0007BCBV\u0007\u000f\f\t\u00111\u0001\u00028!\u001a\u0002a!5\u0004X\u000ee7Q\\Bp\u0007G\u001c)o!;\u0004lB\u0019\u0011ca5\n\u0007\rU'AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\rm\u0017\u0001b\u001e\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;beRd\u0003e\u001d;pa2\u00023\u000f^3qS\u0001j\u0003eR3oKJ\fG/Z:!C:\u0004\u0013M\u001d:bs\u0002zg\rI3mK6,g\u000e^:!MJ|W\u000eI:uCJ$\b\u0005^8!gR|\u0007\u000f\t\u0015j]\u000edWo]5wK&b#\u0002\t\u0011!A\u0001\u0002\u0013N\\2sK6,g\u000e^5oO\u0002\u0012\u0017\u0010I:uKBt\u0003\u0005\u00165fAQL\b/\u001a\u0011pM\u0002\"\b.\u001a\u0011sKR,(O\\3eA\u0015dW-\\3oiN\u0004\u0013n\u001d\u0011uQ\u0016\u00043/Y7fA\u0005\u001c\b\u0005\u001e5fAQL\b/\u001a\u0011pM\u0002\n'oZ;nK:$(\u0002\t\u0011!A\u0001\u0002S\r\u001f9sKN\u001c\u0018n\u001c8t])Q\u0001\u0005\t\u0011!A\u0001\u001aV\u000f\u001d9peR,G\r\t;za\u0016\u001c\b%\u0019:fu\u0001\u0012\u0017\u0010^3-AMDwN\u001d;-A%tG/Z4fe2\u0002Cn\u001c8hY\u0001\"\u0017\r^3-AQLW.Z:uC6\u0004hF\u0003\u0006!A\u0001\u0002\u0003\u0005\t+iK\u0002\u001aH/\u0019:uA\u0005tG\rI:u_B\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tA5,8\u000f\u001e\u0011sKN|GN^3!i>\u0004C\u000f[3!g\u0006lW\r\t;za\u0016t#\u0002\t\u0011!A\u0001\u0002\u0013J\u001a\u0011ti\u0006\u0014H\u000fI1oI\u0002\u001aHo\u001c9!Kb\u0004(/Z:tS>t7\u000f\t:fg>dg/\u001a\u0011u_\u0002\"\b.\u001a\u0011(I\u0006$Xm\n\u0011pe\u0002:C/[7fgR\fW\u000e]\u0014!if\u0004XM\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e5f]\u0002\"\b.\u001a\u0011ti\u0016\u0004\b%\u001a=qe\u0016\u001c8/[8oA5,8\u000f\u001e\u0011sKN|GN^3!i>\u0004C\u000f[3!O%tG/\u001a:wC2<\u0003\u0005^=qK2\u0002s\u000e\u001e5fe^L7/\u001a\u0011u_\u0002\"\b.\u001a\u0011tC6,\u0007\u0005^=qK*\u0001\u0003\u0005\t\u0011!A\u0005\u001c\b\u0005\u001e5fAM$\u0018M\u001d;!C:$\u0007e\u001d;pa\u0002*\u0007\u0010\u001d:fgNLwN\\:/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\u0019\t/AB;\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f^1si\u0002j\u0003%\u00198!Kb\u0004(/Z:tS>tg\u0006\t+iK\u0002\u001aH/\u0019:uA=4\u0007\u0005\u001e5fAI\fgnZ3/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aHo\u001c9![\u0001\ng\u000eI3yaJ,7o]5p]:\u0002C\u000b[3!K:$\u0007\u0005\u001e5fAI\fgnZ3!Q%t7\r\\;tSZ,\u0017F\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR,\u0007\u000fI\u0017!C:\u0004s\u000e\u001d;j_:\fG\u000eI3yaJ,7o]5p]:\u0002C\u000b[3!gR,\u0007\u000fI8gAQDW\r\t:b]\u001e,gF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\tK\b\u0005Z3gCVdG\u000fI:uKB\u0004\u0013n\u001d\u00112A%4\u0007e\u001d;beR\u0004\u0013n\u001d\u0011mKN\u001c\b\u0005\u001e5b]\u0002z'\u000fI3rk\u0006d\u0007\u0005^8!gR|\u0007\u000f\f\u0011pi\",'o^5tK\u0002j\u0013G\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u00012uN\u001d\u0011uQ\u0016\u0004C/Z7q_J\fG\u000eI:fcV,gnY3tA%$xe\u001d\u00112A\u0011\f\u0017\u0010I1oI\u0002j\u0013\u0007\t3bs\u0002\u0012Xm\u001d9fGRLg/\u001a7z])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I%gAM$\u0018M\u001d;!SN\u0004sM]3bi\u0016\u0014\b\u0005\u001e5b]\u0002\u001aHo\u001c9!i\",g\u000e\t;iK\u0002\u001aH/\u001a9![V\u001cH\u000f\t2fA9,w-\u0019;jm\u0016d\u0003%\u00198eAYL7-\u001a\u0011wKJ\u001c\u0018M\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0004h\u0006\t)O\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152Y\u0001*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012Df\r\u00175YUj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u001b-AEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.6YQb3\u0007\f\u001a-cuS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006^8`I\u0006$X\rK\u00143aEBT\u0006M\u0019.aE:\u0013\u0006\f\u0011u_~#\u0017\r^3)OI\u0002\u0014\u0007O\u00171g5\u0002\u0014gJ\u0015-A%tG/\u001a:wC2\u0004\u0013\u0007I7p]RD\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\eA\n\u0004(\f\u00192[A\nDF\r\u00192q5\u0002$'\f\u00192YI\u0002\u0014\u0007O\u00171g5\u0002\u0014'\u0018\u0006!A\u0005)1/\u001b8dK\u0006\u00121Q^\u0001\u0006e9\"d\u0006\r")
public class Sequence
extends Expression
implements TimeZoneAwareExpression,
Serializable {
    private final Expression start;
    private final Expression stop;
    private final Option<Expression> stepOpt;
    private final Option<String> timeZoneId;
    private transient SequenceImpl org$apache$spark$sql$catalyst$expressions$Sequence$$impl;
    private final boolean resolved;
    private final transient TimeZone timeZone;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> apply$default$4() {
        return Sequence$.MODULE$.apply$default$4();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return Sequence$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Option<Expression>, Option<String>>> unapply(Sequence sequence) {
        return Sequence$.MODULE$.unapply(sequence);
    }

    private SequenceImpl org$apache$spark$sql$catalyst$expressions$Sequence$$impl$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                SequenceImpl sequenceImpl;
                DataType dataType2 = this.dataType().elementType();
                if (dataType2 instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType2;
                    ClassTag ct = ClassTag$.MODULE$.apply((Class)((Mirrors.RuntimeMirror)integralType.tag().mirror()).runtimeClass(integralType.tag().tpe()));
                    sequenceImpl = new IntegralSequenceImpl<Object>(integralType, ct, integralType.integral());
                } else if (TimestampType$.MODULE$.equals(dataType2)) {
                    sequenceImpl = new TemporalSequenceImpl(LongType$.MODULE$, 1L, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(long x) {
                            return this.apply$mcJJ$sp(x);
                        }

                        public long apply$mcJJ$sp(long x) {
                            return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
                        }
                    }, this.timeZone(), ClassTag$.MODULE$.Long(), Numeric.LongIsIntegral$.MODULE$);
                } else {
                    if (!DateType$.MODULE$.equals(dataType2)) {
                        throw new MatchError((Object)dataType2);
                    }
                    sequenceImpl = new TemporalSequenceImpl(IntegerType$.MODULE$, 86400000000L, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(long x$64) {
                            return this.apply$mcIJ$sp(x$64);
                        }

                        public int apply$mcIJ$sp(long x$64) {
                            return (int)x$64;
                        }
                    }, this.timeZone(), ClassTag$.MODULE$.Int(), Numeric.IntIsIntegral$.MODULE$);
                }
                this.org$apache$spark$sql$catalyst$expressions$Sequence$$impl = sequenceImpl;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.org$apache$spark$sql$catalyst$expressions$Sequence$$impl;
        }
    }

    private boolean resolved$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression$class.resolved(this);
                this.bitmap$0 = true;
            }
            return this.resolved;
        }
    }

    @Override
    public boolean resolved() {
        return this.bitmap$0 ? this.resolved : this.resolved$lzycompute();
    }

    private TimeZone timeZone$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.timeZone = TimeZoneAwareExpression$class.timeZone(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.timeZone;
        }
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public Expression start() {
        return this.start;
    }

    public Expression stop() {
        return this.stop;
    }

    public Option<Expression> stepOpt() {
        return this.stepOpt;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$89 = new Some((Object)timeZoneId);
        Expression x$90 = this.copy$default$1();
        Expression x$91 = this.copy$default$2();
        Option<Expression> x$92 = this.copy$default$3();
        return this.copy(x$90, x$91, x$92, (Option<String>)x$89);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.start(), this.stop()}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.stepOpt()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$61) {
                return x$61.foldable();
            }
        });
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$62) {
                return x$62.nullable();
            }
        });
    }

    @Override
    public ArrayType dataType() {
        return new ArrayType(this.start().dataType(), false);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType2;
        boolean bl;
        boolean bl2;
        DataType startType = this.start().dataType();
        boolean typesCorrect = startType.sameType(this.stop().dataType()) && (bl2 = (bl = TimestampType$.MODULE$.equals(dataType2 = startType) ? true : DateType$.MODULE$.equals(dataType2)) ? this.stepOpt().isEmpty() || CalendarIntervalType$.MODULE$.acceptsType(this.stepType$1()) : (dataType2 instanceof IntegralType ? this.stepOpt().isEmpty() || this.stepType$1().sameType(startType) : false));
        return typesCorrect ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " only supports integral, timestamp or date types"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()})));
    }

    public Seq<Expression> coercibleChildren() {
        return (Seq)this.children().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$63) {
                DataType dataType2 = x$63.dataType();
                CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
                return dataType2 != null ? !dataType2.equals(calendarIntervalType$) : calendarIntervalType$ != null;
            }
        });
    }

    public Expression castChildrenTo(DataType widerType) {
        return new Sequence(new Cast(this.start(), widerType, Cast$.MODULE$.apply$default$3()), new Cast(this.stop(), widerType, Cast$.MODULE$.apply$default$3()), (Option<Expression>)this.stepOpt().map((Function1)new Serializable(this, widerType){
            public static final long serialVersionUID = 0L;
            private final DataType widerType$1;

            public final Expression apply(Expression step) {
                DataType dataType2 = step.dataType();
                CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
                return !(dataType2 != null ? !dataType2.equals(calendarIntervalType$) : calendarIntervalType$ != null) ? step : new Cast(step, this.widerType$1, Cast$.MODULE$.apply$default$3());
            }
            {
                this.widerType$1 = widerType$1;
            }
        }), this.timeZoneId());
    }

    public SequenceImpl org$apache$spark$sql$catalyst$expressions$Sequence$$impl() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.org$apache$spark$sql$catalyst$expressions$Sequence$$impl$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$Sequence$$impl;
    }

    @Override
    public Object eval(InternalRow input) {
        Object startVal = this.start().eval(input);
        if (startVal == null) {
            return null;
        }
        Object stopVal = this.stop().eval(input);
        if (stopVal == null) {
            return null;
        }
        Object stepVal = this.stepOpt().map((Function1)new Serializable(this, input){
            public static final long serialVersionUID = 0L;
            private final InternalRow input$4;

            public final Object apply(Expression x$65) {
                return x$65.eval(this.input$4);
            }
            {
                this.input$4 = input$4;
            }
        }).getOrElse((Function0)new Serializable(this, startVal, stopVal){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Sequence $outer;
            private final Object startVal$1;
            private final Object stopVal$1;

            public final Object apply() {
                return this.$outer.org$apache$spark$sql$catalyst$expressions$Sequence$$impl().defaultStep().apply(this.startVal$1, this.stopVal$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.startVal$1 = startVal$1;
                this.stopVal$1 = stopVal$1;
            }
        });
        if (stepVal == null) {
            return null;
        }
        return ArrayData$.MODULE$.toArrayData(this.org$apache$spark$sql$catalyst$expressions$Sequence$$impl().eval(startVal, stopVal, stepVal));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        ExprCode startGen = this.start().genCode(ctx);
        ExprCode stopGen = this.stop().genCode(ctx);
        ExprCode stepGen = (ExprCode)this.stepOpt().map((Function1)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final CodegenContext ctx$15;

            public final ExprCode apply(Expression x$66) {
                return x$66.genCode(this.ctx$15);
            }
            {
                this.ctx$15 = ctx$15;
            }
        }).getOrElse((Function0)new Serializable(this, ctx, startGen, stopGen){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Sequence $outer;
            private final CodegenContext ctx$15;
            private final ExprCode startGen$1;
            private final ExprCode stopGen$1;

            public final ExprCode apply() {
                return this.$outer.org$apache$spark$sql$catalyst$expressions$Sequence$$impl().defaultStep().genCode(this.ctx$15, this.startGen$1, this.stopGen$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ctx$15 = ctx$15;
                this.startGen$1 = startGen$1;
                this.stopGen$1 = stopGen$1;
            }
        });
        String resultType = CodeGenerator$.MODULE$.javaType(this.dataType());
        String arr = ctx.freshName("arr");
        String arrElemType = CodeGenerator$.MODULE$.javaType(this.dataType().elementType());
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |final ", "[] ", " = null;\n         |", "\n         |", " = UnsafeArrayData.fromPrimitiveArray(", ");\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arrElemType, arr, this.org$apache$spark$sql$catalyst$expressions$Sequence$$impl().genCode(ctx, ExprValue$.MODULE$.exprValueToString(startGen.value()), ExprValue$.MODULE$.exprValueToString(stopGen.value()), ExprValue$.MODULE$.exprValueToString(stepGen.value()), arr, arrElemType), ev.value(), arr})))).stripMargin();
        if (this.nullable()) {
            String nullSafeEval2 = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)startGen.code()), ctx.nullSafeExec(this.start().nullable(), ExprValue$.MODULE$.exprValueToString(startGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)stopGen.code()), ctx.nullSafeExec(this.stop().nullable(), ExprValue$.MODULE$.exprValueToString(stopGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)stepGen.code()), ctx.nullSafeExec(this.stepOpt().exists((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Expression x$67) {
                    return x$67.nullable();
                }
            }), ExprValue$.MODULE$.exprValueToString(stepGen.isNull()), new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |", " = false;\n                 |", "\n               "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), resultCode})))).stripMargin()))))));
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |", " ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), resultType, ev.value(), nullSafeEval2})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
        } else {
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |", "\n           |", "\n           |", " ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{startGen.code(), stopGen.code(), stepGen.code(), resultType, ev.value(), resultCode})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        return exprCode;
    }

    public Sequence copy(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        return new Sequence(start, stop, stepOpt, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.start();
    }

    public Expression copy$default$2() {
        return this.stop();
    }

    public Option<Expression> copy$default$3() {
        return this.stepOpt();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Sequence";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            case 2: {
                object = this.stepOpt();
                break;
            }
            case 1: {
                object = this.stop();
                break;
            }
            case 0: {
                object = this.start();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sequence)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sequence sequence = (Sequence)x$1;
        Expression expression = this.start();
        Expression expression2 = sequence.start();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.stop();
        Expression expression4 = sequence.stop();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.stepOpt();
        Option<Expression> option2 = sequence.stepOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = sequence.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!sequence.canEqual(this)) return false;
        return true;
    }

    private final DataType stepType$1() {
        return ((Expression)this.stepOpt().get()).dataType();
    }

    public Sequence(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        this.start = start;
        this.stop = stop;
        this.stepOpt = stepOpt;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression$class.$init$(this);
    }

    public Sequence(Expression start, Expression stop) {
        this(start, stop, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Sequence(Expression start, Expression stop, Expression step) {
        this(start, stop, (Option<Expression>)new Some((Object)step), (Option<String>)None$.MODULE$);
    }

    public static class DefaultStep {
        private final Function2<Object, Object, Object> lteq;
        private final DataType stepType;
        private final Object one;
        private final Object negativeOne;

        private Object negativeOne() {
            return this.negativeOne;
        }

        public Object apply(Object start, Object stop) {
            return BoxesRunTime.unboxToBoolean((Object)this.lteq.apply(start, stop)) ? this.one : this.negativeOne();
        }

        public ExprCode genCode(CodegenContext ctx, ExprCode startGen, ExprCode stopGen) {
            Seq seq = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.one, this.negativeOne()}))).map((Function1)new Serializable(this, ctx){
                public static final long serialVersionUID = 0L;
                private final CodegenContext ctx$16;

                public final ExprValue apply(Object x$68) {
                    return Literal$.MODULE$.apply(x$68).genCode(this.ctx$16).value();
                }
                {
                    this.ctx$16 = ctx$16;
                }
            }, Seq$.MODULE$.canBuildFrom());
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                Tuple2 tuple2;
                ExprValue oneVal = (ExprValue)((SeqLike)some.get()).apply(0);
                ExprValue negativeOneVal = (ExprValue)((SeqLike)some.get()).apply(1);
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)oneVal, (Object)negativeOneVal);
                ExprValue oneVal2 = (ExprValue)tuple22._1();
                ExprValue negativeOneVal2 = (ExprValue)tuple22._2();
                return ExprCode$.MODULE$.forNonNullValue(JavaCode$.MODULE$.expression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " <= ", " ? ", " : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{startGen.value(), stopGen.value(), oneVal2, negativeOneVal2})), this.stepType));
            }
            throw new MatchError((Object)seq);
        }

        public DefaultStep(Function2<Object, Object, Object> lteq, DataType stepType, Object one) {
            this.lteq = lteq;
            this.stepType = stepType;
            this.one = one;
            UnaryMinus qual$1 = new UnaryMinus(Literal$.MODULE$.apply(one));
            InternalRow x$93 = qual$1.eval$default$1();
            this.negativeOne = qual$1.eval(x$93);
        }
    }

    public static interface SequenceImpl {
        public Object eval(Object var1, Object var2, Object var3);

        public String genCode(CodegenContext var1, String var2, String var3, String var4, String var5, String var6);

        public DefaultStep defaultStep();
    }

    public static class IntegralSequenceImpl<T>
    implements SequenceImpl {
        public final IntegralType org$apache$spark$sql$catalyst$expressions$Sequence$IntegralSequenceImpl$$elemType;
        private final ClassTag<T> evidence$1;
        private final Integral<T> num;
        private final DefaultStep defaultStep;

        @Override
        public DefaultStep defaultStep() {
            return this.defaultStep;
        }

        @Override
        public Object eval(Object input1, Object input2, Object input3) {
            Object start = input1;
            Object stop = input2;
            Object step = input3;
            int i = Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(start, stop, step, this.num);
            Object arr = this.evidence$1.newArray(i);
            while (i > 0) {
                ScalaRunTime$.MODULE$.array_update(arr, --i, this.num.mkNumericOps(start).$plus(this.num.mkNumericOps(step).$times(this.num.fromInt(i))));
            }
            return arr;
        }

        @Override
        public String genCode(CodegenContext ctx, String start, String stop, String step, String arr, String elemType) {
            String i = ctx.freshName("i");
            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", " = new ", "[", "];\n         |while (", " > 0) {\n         |  ", "--;\n         |  ", "[", "] = (", ") (", " + ", " * ", ");\n         |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(ctx, start, stop, step, i), arr, elemType, i, i, i, arr, i, elemType, start, step, i})))).stripMargin();
        }

        public IntegralSequenceImpl(IntegralType elemType, ClassTag<T> evidence$1, Integral<T> num) {
            this.org$apache$spark$sql$catalyst$expressions$Sequence$IntegralSequenceImpl$$elemType = elemType;
            this.evidence$1 = evidence$1;
            this.num = num;
            this.defaultStep = new DefaultStep((Function2<Object, Object, Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IntegralSequenceImpl $outer;

                public final boolean apply(Object x, Object y) {
                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Sequence$IntegralSequenceImpl$$elemType.ordering().lteq(x, y);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, elemType, num.one());
        }
    }

    public static class TemporalSequenceImpl<T>
    implements SequenceImpl {
        public final IntegralType org$apache$spark$sql$catalyst$expressions$Sequence$TemporalSequenceImpl$$dt;
        private final long scale;
        private final Function1<Object, T> fromLong;
        private final TimeZone timeZone;
        private final ClassTag<T> evidence$2;
        private final Integral<T> num;
        private final DefaultStep defaultStep;
        private final IntegralSequenceImpl<T> backedSequenceImpl;
        private final long microsPerMonth;

        @Override
        public DefaultStep defaultStep() {
            return this.defaultStep;
        }

        private IntegralSequenceImpl<T> backedSequenceImpl() {
            return this.backedSequenceImpl;
        }

        private long microsPerMonth() {
            return this.microsPerMonth;
        }

        @Override
        public Object eval(Object input1, Object input2, Object input3) {
            Object object;
            Object start = input1;
            Object stop = input2;
            CalendarInterval step = (CalendarInterval)input3;
            int stepMonths = step.months;
            long stepMicros = step.microseconds;
            if (stepMonths == 0) {
                object = this.backedSequenceImpl().eval(start, stop, this.fromLong.apply((Object)BoxesRunTime.boxToLong((long)(stepMicros / this.scale))));
            } else {
                long intervalStepInMicros = stepMicros + (long)stepMonths * this.microsPerMonth();
                long startMicros = this.num.toLong(start) * this.scale;
                long stopMicros = this.num.toLong(stop) * this.scale;
                int maxEstimatedArrayLength = Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(BoxesRunTime.boxToLong((long)startMicros), BoxesRunTime.boxToLong((long)stopMicros), BoxesRunTime.boxToLong((long)intervalStepInMicros), Numeric.LongIsIntegral$.MODULE$);
                int stepSign = stopMicros > startMicros ? 1 : -1;
                long exclusiveItem = stopMicros + (long)stepSign;
                Object arr = this.evidence$2.newArray(maxEstimatedArrayLength);
                long t = startMicros;
                int i = 0;
                while (t < exclusiveItem ^ stepSign < 0) {
                    ScalaRunTime$.MODULE$.array_update(arr, i, this.fromLong.apply((Object)BoxesRunTime.boxToLong((long)(t / this.scale))));
                    t = DateTimeUtils$.MODULE$.timestampAddInterval(t, stepMonths, stepMicros, this.timeZone);
                    ++i;
                }
                object = ScalaRunTime$.MODULE$.array_length(arr) == i ? arr : Predef$.MODULE$.genericArrayOps(arr).slice(0, i);
            }
            return object;
        }

        @Override
        public String genCode(CodegenContext ctx, String start, String stop, String step, String arr, String elemType) {
            String stepMonths = ctx.freshName("stepMonths");
            String stepMicros = ctx.freshName("stepMicros");
            String stepScaled = ctx.freshName("stepScaled");
            String intervalInMicros = ctx.freshName("intervalInMicros");
            String startMicros = ctx.freshName("startMicros");
            String stopMicros = ctx.freshName("stopMicros");
            String arrLength = ctx.freshName("arrLength");
            String stepSign = ctx.freshName("stepSign");
            String exclusiveItem = ctx.freshName("exclusiveItem");
            String t = ctx.freshName("t");
            String i = ctx.freshName("i");
            String genTimeZone = ctx.addReferenceObj("timeZone", this.timeZone, TimeZone.class.getName());
            String sequenceLengthCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |final long ", " = ", " + ", " * ", "L;\n           |", "\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{intervalInMicros, stepMicros, stepMonths, BoxesRunTime.boxToLong((long)this.microsPerMonth()), Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(ctx, startMicros, stopMicros, intervalInMicros, arrLength)})))).stripMargin();
            String timestampAddIntervalCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", " = org.apache.spark.sql.catalyst.util.DateTimeUtils.timestampAddInterval(\n           |  ", ", ", ", ", ", ", ");\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t, t, stepMonths, stepMicros, genTimeZone})))).stripMargin();
            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |final int ", " = ", ".months;\n         |final long ", " = ", ".microseconds;\n         |\n         |if (", " == 0) {\n         |  final ", " ", " = (", ") (", " / ", "L);\n         |  ", ";\n         |\n         |} else {\n         |  final long ", " = ", " * ", "L;\n         |  final long ", " = ", " * ", "L;\n         |\n         |  ", "\n         |\n         |  final int ", " = ", " > ", " ? +1 : -1;\n         |  final long ", " = ", " + ", ";\n         |\n         |  ", " = new ", "[", "];\n         |  long ", " = ", ";\n         |  int ", " = 0;\n         |\n         |  while (", " < ", " ^ ", " < 0) {\n         |    ", "[", "] = (", ") (", " / ", "L);\n         |    ", "\n         |    ", " += 1;\n         |  }\n         |\n         |  if (", ".length > ", ") {\n         |    ", " = java.util.Arrays.copyOf(", ", ", ");\n         |  }\n         |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stepMonths, step, stepMicros, step, stepMonths, elemType, stepScaled, elemType, stepMicros, BoxesRunTime.boxToLong((long)this.scale), this.backedSequenceImpl().genCode(ctx, start, stop, stepScaled, arr, elemType), startMicros, start, BoxesRunTime.boxToLong((long)this.scale), stopMicros, stop, BoxesRunTime.boxToLong((long)this.scale), sequenceLengthCode, stepSign, stopMicros, startMicros, exclusiveItem, stopMicros, stepSign, arr, elemType, arrLength, t, startMicros, i, t, exclusiveItem, stepSign, arr, i, elemType, t, BoxesRunTime.boxToLong((long)this.scale), timestampAddIntervalCode, i, arr, i, arr, arr, i})))).stripMargin();
        }

        public TemporalSequenceImpl(IntegralType dt, long scale, Function1<Object, T> fromLong, TimeZone timeZone, ClassTag<T> evidence$2, Integral<T> num) {
            this.org$apache$spark$sql$catalyst$expressions$Sequence$TemporalSequenceImpl$$dt = dt;
            this.scale = scale;
            this.fromLong = fromLong;
            this.timeZone = timeZone;
            this.evidence$2 = evidence$2;
            this.num = num;
            this.defaultStep = new DefaultStep((Function2<Object, Object, Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TemporalSequenceImpl $outer;

                public final boolean apply(Object x, Object y) {
                    return this.$outer.org$apache$spark$sql$catalyst$expressions$Sequence$TemporalSequenceImpl$$dt.ordering().lteq(x, y);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, CalendarIntervalType$.MODULE$, new CalendarInterval(0, 86400000000L));
            this.backedSequenceImpl = new IntegralSequenceImpl<T>(dt, evidence$2, num);
            this.microsPerMonth = 2419200000000L;
        }
    }
}

