/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.persistence;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.store.cassandra.common.PropertyMappingHelper;
import org.apache.ignite.cache.store.cassandra.persistence.PojoFieldAccessor;
import org.apache.ignite.cache.store.cassandra.serializer.Serializer;
import org.w3c.dom.Element;

public abstract class PojoField
implements Serializable {
    private static final String NAME_ATTR = "name";
    private static final String COLUMN_ATTR = "column";
    private String name;
    private String col;
    private String colDDL;
    private Boolean calculated;
    private transient PojoFieldAccessor accessor;

    public static boolean containsField(List<PojoField> list, String string) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (PojoField pojoField : list) {
            if (!pojoField.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public PojoField(Element element, Class<?> clazz) {
        if (element == null) {
            throw new IllegalArgumentException("DOM element representing POJO field object can't be null");
        }
        if (!element.hasAttribute(NAME_ATTR)) {
            throw new IllegalArgumentException("DOM element representing POJO field object should have 'name' attribute");
        }
        this.name = element.getAttribute(NAME_ATTR).trim();
        this.col = element.hasAttribute(COLUMN_ATTR) ? element.getAttribute(COLUMN_ATTR).trim() : this.name.toLowerCase();
        this.init(PropertyMappingHelper.getPojoFieldAccessor(clazz, this.name));
    }

    public PojoField(PojoFieldAccessor pojoFieldAccessor) {
        this.name = pojoFieldAccessor.getName();
        QuerySqlField querySqlField = (QuerySqlField)pojoFieldAccessor.getAnnotation(QuerySqlField.class);
        this.col = querySqlField != null && querySqlField.name() != null && !querySqlField.name().isEmpty() ? querySqlField.name() : this.name.toLowerCase();
        this.init(pojoFieldAccessor);
    }

    public String getName() {
        return this.name;
    }

    public Class getJavaClass() {
        return this.accessor.getFieldType();
    }

    public String getColumn() {
        return this.col;
    }

    public String getColumnDDL() {
        return this.colDDL;
    }

    public boolean calculatedField() {
        if (this.calculated != null) {
            return this.calculated;
        }
        this.calculated = this.accessor.isReadOnly();
        return this.calculated;
    }

    public Object getValueFromObject(Object object, Serializer serializer) {
        Object object2 = this.accessor.getValue(object);
        if (object2 == null) {
            return null;
        }
        DataType.Name name = PropertyMappingHelper.getCassandraType(object2.getClass());
        if (name != null) {
            return object2;
        }
        if (serializer == null) {
            throw new IllegalStateException("Can't serialize value from object '" + object2.getClass().getName() + "' field '" + this.name + "', cause there is no BLOB serializer specified");
        }
        return serializer.serialize(object2);
    }

    public Annotation getAnnotation(Class clazz) {
        return this.accessor.getAnnotation(clazz);
    }

    public void setValueFromRow(Row row, Object object, Serializer serializer) {
        if (this.calculatedField()) {
            return;
        }
        Object object2 = PropertyMappingHelper.getCassandraColumnValue(row, this.col, this.accessor.getFieldType(), serializer);
        this.accessor.setValue(object, object2);
    }

    private void init(PojoFieldAccessor pojoFieldAccessor) {
        DataType.Name name = PropertyMappingHelper.getCassandraType(pojoFieldAccessor.getFieldType());
        name = name == null ? DataType.Name.BLOB : name;
        this.colDDL = "\"" + this.col + "\" " + name.toString();
        this.accessor = pojoFieldAccessor;
    }
}

