/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.persistence;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.store.cassandra.common.PropertyMappingHelper;
import org.apache.ignite.cache.store.cassandra.persistence.KeyPersistenceSettings;
import org.apache.ignite.cache.store.cassandra.persistence.KeyValuePersistenceSettings;
import org.apache.ignite.cache.store.cassandra.persistence.PersistenceSettings;
import org.apache.ignite.cache.store.cassandra.persistence.PersistenceStrategy;
import org.apache.ignite.cache.store.cassandra.persistence.PojoField;
import org.apache.ignite.cache.store.cassandra.persistence.ValuePersistenceSettings;
import org.apache.ignite.cache.store.cassandra.serializer.Serializer;

public class PersistenceController {
    private final KeyValuePersistenceSettings persistenceSettings;
    private final List<PojoField> keyUniquePojoFields;
    private final List<PojoField> valUniquePojoFields;
    private final String writeStatementTempl;
    private final String delStatementTempl;
    private final String loadStatementTempl;
    private final String loadWithKeyFieldsStatementTempl;
    private volatile Map<String, String> writeStatements = new HashMap<String, String>();
    private volatile Map<String, String> delStatements = new HashMap<String, String>();
    private volatile Map<String, String> loadStatements = new HashMap<String, String>();
    private volatile Map<String, String> loadWithKeyFieldsStatements = new HashMap<String, String>();

    public PersistenceController(KeyValuePersistenceSettings keyValuePersistenceSettings) {
        if (keyValuePersistenceSettings == null) {
            throw new IllegalArgumentException("Persistent settings can't be null");
        }
        this.persistenceSettings = keyValuePersistenceSettings;
        String[] stringArray = this.prepareLoadStatements();
        this.loadWithKeyFieldsStatementTempl = stringArray[0];
        this.loadStatementTempl = stringArray[1];
        this.writeStatementTempl = this.prepareWriteStatement();
        this.delStatementTempl = this.prepareDeleteStatement();
        this.keyUniquePojoFields = keyValuePersistenceSettings.getKeyPersistenceSettings().cassandraUniqueFields();
        List<PojoField> list = keyValuePersistenceSettings.getValuePersistenceSettings().cassandraUniqueFields();
        if (list == null || list.isEmpty()) {
            this.valUniquePojoFields = list;
            return;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.keyUniquePojoFields == null) {
            linkedList.add(keyValuePersistenceSettings.getKeyPersistenceSettings().getColumn());
        } else {
            for (PojoField object : this.keyUniquePojoFields) {
                linkedList.add(object.getColumn());
            }
        }
        LinkedList<PojoField> linkedList2 = new LinkedList<PojoField>(list);
        block1: for (String string : linkedList) {
            for (int i = 0; i < linkedList2.size(); ++i) {
                if (!string.equals(((PojoField)linkedList2.get(i)).getColumn())) continue;
                linkedList2.remove(i);
                continue block1;
            }
        }
        this.valUniquePojoFields = linkedList2.isEmpty() ? null : Collections.unmodifiableList(linkedList2);
    }

    public KeyValuePersistenceSettings getPersistenceSettings() {
        return this.persistenceSettings;
    }

    public String getWriteStatement(String string) {
        return this.getStatement(string, this.writeStatementTempl, this.writeStatements);
    }

    public String getDeleteStatement(String string) {
        return this.getStatement(string, this.delStatementTempl, this.delStatements);
    }

    public String getLoadStatement(String string, boolean bl) {
        return bl ? this.getStatement(string, this.loadWithKeyFieldsStatementTempl, this.loadWithKeyFieldsStatements) : this.getStatement(string, this.loadStatementTempl, this.loadStatements);
    }

    public BoundStatement bindKey(PreparedStatement preparedStatement, Object object) {
        KeyPersistenceSettings keyPersistenceSettings = this.persistenceSettings.getKeyPersistenceSettings();
        Object[] objectArray = PersistenceStrategy.POJO != keyPersistenceSettings.getStrategy() ? new Object[1] : new Object[this.keyUniquePojoFields.size()];
        this.bindValues(keyPersistenceSettings.getStrategy(), keyPersistenceSettings.getSerializer(), this.keyUniquePojoFields, object, objectArray, 0);
        return preparedStatement.bind(objectArray);
    }

    public BoundStatement bindKeyValue(PreparedStatement preparedStatement, Object object, Object object2) {
        Object[] objectArray = new Object[this.persistenceSettings.getTableColumns().size()];
        KeyPersistenceSettings keyPersistenceSettings = this.persistenceSettings.getKeyPersistenceSettings();
        ValuePersistenceSettings valuePersistenceSettings = this.persistenceSettings.getValuePersistenceSettings();
        int n = this.bindValues(keyPersistenceSettings.getStrategy(), keyPersistenceSettings.getSerializer(), this.keyUniquePojoFields, object, objectArray, 0);
        this.bindValues(valuePersistenceSettings.getStrategy(), valuePersistenceSettings.getSerializer(), this.valUniquePojoFields, object2, objectArray, n);
        return preparedStatement.bind(objectArray);
    }

    public Object buildKeyObject(Row row) {
        return this.buildObject(row, this.persistenceSettings.getKeyPersistenceSettings());
    }

    public Object buildValueObject(Row row) {
        return this.buildObject(row, this.persistenceSettings.getValuePersistenceSettings());
    }

    private String prepareWriteStatement() {
        List<String> list = this.persistenceSettings.getTableColumns();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String string : list) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
                stringBuilder2.append(",");
            }
            stringBuilder.append("\"").append(string).append("\"");
            stringBuilder2.append("?");
        }
        Object object = "insert into \"" + this.persistenceSettings.getKeyspace() + "\".\"%1$s\" (" + stringBuilder + ") values (" + stringBuilder2 + ")";
        if (this.persistenceSettings.getTTL() != null) {
            object = (String)object + " using ttl " + this.persistenceSettings.getTTL();
        }
        return (String)object + ";";
    }

    private String prepareDeleteStatement() {
        List<String> list = this.persistenceSettings.getKeyPersistenceSettings().getTableColumns();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(" and ");
            }
            stringBuilder.append("\"").append(string).append("\"=?");
        }
        stringBuilder.append(";");
        return "delete from \"" + this.persistenceSettings.getKeyspace() + "\".\"%1$s\" where " + stringBuilder;
    }

    private String[] prepareLoadStatements() {
        PersistenceSettings persistenceSettings = this.persistenceSettings.getKeyPersistenceSettings();
        boolean bl = PersistenceStrategy.POJO == persistenceSettings.getStrategy();
        List<String> list = persistenceSettings.getTableColumns();
        StringBuilder stringBuilder = new StringBuilder();
        for (String charSequence2 : list) {
            if (bl && persistenceSettings.getFieldByColumn(charSequence2).calculatedField()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("\"").append(charSequence2).append("\"");
        }
        persistenceSettings = this.persistenceSettings.getValuePersistenceSettings();
        bl = PersistenceStrategy.POJO == persistenceSettings.getStrategy();
        List<String> list2 = persistenceSettings.getTableColumns();
        StringBuilder stringBuilder2 = new StringBuilder();
        Object object = list2.iterator();
        while (object.hasNext()) {
            String n = (String)object.next();
            if (bl && persistenceSettings.getFieldByColumn(n).calculatedField()) continue;
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(", ");
            }
            stringBuilder2.append("\"").append(n).append("\"");
            if (list.contains(n)) continue;
            stringBuilder.append(", \"").append(n).append("\"");
        }
        stringBuilder.insert(0, "select ");
        stringBuilder2.insert(0, "select ");
        object = new StringBuilder();
        ((StringBuilder)object).append(" from \"");
        ((StringBuilder)object).append(this.persistenceSettings.getKeyspace());
        ((StringBuilder)object).append("\".\"%1$s");
        ((StringBuilder)object).append("\" where ");
        int n = 0;
        for (String string : list) {
            if (n > 0) {
                ((StringBuilder)object).append(" and ");
            }
            ((StringBuilder)object).append("\"").append(string).append("\"=?");
            ++n;
        }
        ((StringBuilder)object).append(";");
        return new String[]{stringBuilder + ((StringBuilder)object).toString(), stringBuilder2 + ((StringBuilder)object).toString()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStatement(String string, String string2, Map<String, String> map) {
        Map<String, String> map2 = map;
        synchronized (map2) {
            String string3 = map.get(string);
            if (string3 == null) {
                string3 = String.format(string2, string);
                map.put(string, string3);
            }
            return string3;
        }
    }

    private Object buildObject(Row row, PersistenceSettings persistenceSettings) {
        Object t;
        if (row == null) {
            return null;
        }
        PersistenceStrategy persistenceStrategy = persistenceSettings.getStrategy();
        Class clazz = persistenceSettings.getJavaClass();
        String string = persistenceSettings.getColumn();
        if (PersistenceStrategy.PRIMITIVE == persistenceStrategy) {
            return PropertyMappingHelper.getCassandraColumnValue(row, string, clazz, null);
        }
        if (PersistenceStrategy.BLOB == persistenceStrategy) {
            return persistenceSettings.getSerializer().deserialize(row.getBytes(string));
        }
        List<PojoField> list = persistenceSettings.getFields();
        try {
            t = clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw new IgniteException("Failed to instantiate object of type '" + clazz.getName() + "' using reflection", throwable);
        }
        for (PojoField pojoField : list) {
            if (pojoField.calculatedField()) continue;
            pojoField.setValueFromRow(row, t, persistenceSettings.getSerializer());
        }
        return t;
    }

    private int bindValues(PersistenceStrategy persistenceStrategy, Serializer serializer, List<PojoField> list, Object object, Object[] objectArray, int n) {
        if (PersistenceStrategy.PRIMITIVE == persistenceStrategy) {
            if (PropertyMappingHelper.getCassandraType(object.getClass()) == null || object.getClass().equals(ByteBuffer.class) || object instanceof byte[]) {
                throw new IllegalArgumentException("Couldn't deserialize instance of class '" + object.getClass().getName() + "' using PRIMITIVE strategy. Please use BLOB strategy for this case.");
            }
            objectArray[n] = object;
            return ++n;
        }
        if (PersistenceStrategy.BLOB == persistenceStrategy) {
            objectArray[n] = serializer.serialize(object);
            return ++n;
        }
        if (list == null || list.isEmpty()) {
            return n;
        }
        for (PojoField pojoField : list) {
            Object object2 = pojoField.getValueFromObject(object, serializer);
            if (object2 instanceof byte[]) {
                object2 = ByteBuffer.wrap((byte[])object2);
            }
            objectArray[n] = object2;
            ++n;
        }
        return n;
    }
}

