/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskKilledException;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.source.CodegenMetrics$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$$anonfun$26$;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedClass;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ParentClassLoader;
import org.apache.spark.util.Utils$;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ByteArrayClassLoader;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.InternalCompilerException;
import org.codehaus.janino.SimpleCompiler;
import org.codehaus.janino.util.ClassFile;
import org.slf4j.Logger;
import org.spark_project.guava.cache.CacheBuilder;
import org.spark_project.guava.cache.CacheLoader;
import org.spark_project.guava.cache.LoadingCache;
import org.spark_project.guava.util.concurrent.ExecutionError;
import org.spark_project.guava.util.concurrent.UncheckedExecutionException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class CodeGenerator$
implements Logging {
    public static final CodeGenerator$ MODULE$;
    private final int DEFAULT_JVM_HUGE_METHOD_LIMIT;
    private final int MAX_JVM_METHOD_PARAMS_LENGTH;
    private final int MERGE_SPLIT_METHODS_THRESHOLD;
    private final int GENERATED_CLASS_SIZE_THRESHOLD;
    private final int OUTER_CLASS_VARIABLES_THRESHOLD;
    private final int MUTABLESTATEARRAY_SIZE_LIMIT;
    private final LoadingCache<CodeAndComment, Tuple2<GeneratedClass, Object>> cache;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CodeGenerator$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public final int DEFAULT_JVM_HUGE_METHOD_LIMIT() {
        return 8000;
    }

    public final int MAX_JVM_METHOD_PARAMS_LENGTH() {
        return 255;
    }

    public final int MERGE_SPLIT_METHODS_THRESHOLD() {
        return 3;
    }

    public final int GENERATED_CLASS_SIZE_THRESHOLD() {
        return 1000000;
    }

    public final int OUTER_CLASS_VARIABLES_THRESHOLD() {
        return 10000;
    }

    public final int MUTABLESTATEARRAY_SIZE_LIMIT() {
        return 32768;
    }

    public Tuple2<GeneratedClass, Object> compile(CodeAndComment code) {
        try {
            return (Tuple2)this.cache().get((Object)code);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof UncheckedExecutionException ? true : throwable2 instanceof ExecutionError;
            if (bl) {
                throw throwable2.getCause();
            }
            throw throwable;
        }
    }

    public Tuple2<GeneratedClass, Object> org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$doCompile(CodeAndComment code) {
        int maxCodeSize;
        ClassBodyEvaluator evaluator = new ClassBodyEvaluator();
        ParentClassLoader parentClassLoader = new ParentClassLoader(Utils$.MODULE$.getContextOrSparkClassLoader());
        evaluator.setParentClassLoader((ClassLoader)parentClassLoader);
        evaluator.setClassName("org.apache.spark.sql.catalyst.expressions.GeneratedClass");
        evaluator.setDefaultImports((String[])((Object[])new String[]{Platform.class.getName(), InternalRow.class.getName(), UnsafeRow.class.getName(), UTF8String.class.getName(), Decimal.class.getName(), CalendarInterval.class.getName(), ArrayData.class.getName(), UnsafeArrayData.class.getName(), MapData.class.getName(), UnsafeMapData.class.getName(), Expression.class.getName(), TaskContext.class.getName(), TaskKilledException.class.getName(), InputMetrics.class.getName()}));
        evaluator.setExtendedClass(GeneratedClass.class);
        this.logDebug((Function0<String>)new Serializable(code, evaluator){
            public static final long serialVersionUID = 0L;
            private final CodeAndComment code$1;
            private final ClassBodyEvaluator evaluator$1;

            public final String apply() {
                this.evaluator$1.setDebuggingInformation(true, true, false);
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeFormatter$.MODULE$.format(this.code$1, CodeFormatter$.MODULE$.format$default$2())}));
            }
            {
                this.code$1 = code$1;
                this.evaluator$1 = evaluator$1;
            }
        });
        try {
            evaluator.cook("generated.java", code.body());
            maxCodeSize = this.updateAndGetCompilationStats(evaluator);
        }
        catch (CompileException compileException) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to compile: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compileException}));
            this.logError((Function0<String>)new Serializable(msg){
                public static final long serialVersionUID = 0L;
                private final String msg$2;

                public final String apply() {
                    return this.msg$2;
                }
                {
                    this.msg$2 = msg$2;
                }
            }, compileException);
            int maxLines = SQLConf$.MODULE$.get().loggingMaxLinesForCodegen();
            this.logInfo((Function0<String>)new Serializable(code, maxLines){
                public static final long serialVersionUID = 0L;
                private final CodeAndComment code$1;
                private final int maxLines$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeFormatter$.MODULE$.format(this.code$1, this.maxLines$2)}));
                }
                {
                    this.code$1 = code$1;
                    this.maxLines$2 = maxLines$2;
                }
            });
            throw new CompileException(msg, compileException.getLocation());
        }
        catch (InternalCompilerException internalCompilerException) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to compile: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{internalCompilerException}));
            this.logError((Function0<String>)new Serializable(msg){
                public static final long serialVersionUID = 0L;
                private final String msg$1;

                public final String apply() {
                    return this.msg$1;
                }
                {
                    this.msg$1 = msg$1;
                }
            }, internalCompilerException);
            int maxLines = SQLConf$.MODULE$.get().loggingMaxLinesForCodegen();
            this.logInfo((Function0<String>)new Serializable(code, maxLines){
                public static final long serialVersionUID = 0L;
                private final CodeAndComment code$1;
                private final int maxLines$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeFormatter$.MODULE$.format(this.code$1, this.maxLines$1)}));
                }
                {
                    this.code$1 = code$1;
                    this.maxLines$1 = maxLines$1;
                }
            });
            throw new InternalCompilerException(msg, (Throwable)internalCompilerException);
        }
        return new Tuple2((Object)((GeneratedClass)evaluator.getClazz().newInstance()), (Object)BoxesRunTime.boxToInteger((int)maxCodeSize));
    }

    private int updateAndGetCompilationStats(ClassBodyEvaluator evaluator) {
        Field resultField = SimpleCompiler.class.getDeclaredField("result");
        resultField.setAccessible(true);
        ByteArrayClassLoader loader = (ByteArrayClassLoader)resultField.get(evaluator);
        Field classesField = loader.getClass().getDeclaredField("classes");
        classesField.setAccessible(true);
        scala.collection.mutable.Map classes = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)classesField.get(loader)).asScala();
        Class codeAttr = Utils$.MODULE$.classForName("org.codehaus.janino.util.ClassFile$CodeAttribute");
        Field codeAttrField = codeAttr.getDeclaredField("code");
        codeAttrField.setAccessible(true);
        scala.collection.mutable.Iterable codeSizes = (scala.collection.mutable.Iterable)((GenericTraversableTemplate)classes.flatMap((Function1)new Serializable(codeAttr, codeAttrField){
            public static final long serialVersionUID = 0L;
            public final Class codeAttr$1;
            public final Field codeAttrField$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Iterable<Buffer<Object>> apply(Tuple2<String, byte[]> x0$11) {
                Iterable iterable;
                Tuple2<String, byte[]> tuple2 = x0$11;
                if (tuple2 == null) throw new MatchError(tuple2);
                byte[] classBytes = (byte[])tuple2._2();
                CodegenMetrics$.MODULE$.METRIC_GENERATED_CLASS_BYTECODE_SIZE().update(classBytes.length);
                try {
                    ClassFile cf = new ClassFile((InputStream)new ByteArrayInputStream(classBytes));
                    Buffer stats2 = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cf.methodInfos).asScala()).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.26 $outer;

                        public final ArrayOps<Object> apply(ClassFile.MethodInfo method2) {
                            return Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])method2.getAttributes()).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$26$$anonfun$27 $outer;

                                public final boolean apply(ClassFile.AttributeInfo x$24) {
                                    String string = x$24.getClass().getName();
                                    String string2 = this.$outer.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anonfun$$anonfun$$$outer().codeAttr$1.getName();
                                    return !(string != null ? !string.equals(string2) : string2 != null);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            })).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$26$$anonfun$27 $outer;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final int apply(ClassFile.AttributeInfo a) {
                                    void var2_2;
                                    int byteCodeSize = ((byte[])this.$outer.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anonfun$$anonfun$$$outer().codeAttrField$1.get(a)).length;
                                    CodegenMetrics$.MODULE$.METRIC_GENERATED_METHOD_BYTECODE_SIZE().update(byteCodeSize);
                                    return (int)var2_2;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                        }

                        public /* synthetic */ anonfun.26 org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)stats2));
                    return iterable;
                }
                catch (Throwable throwable) {
                    Iterable iterable2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    CodeGenerator$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Error calculating stats of compiled class.";
                        }
                    }, e);
                    iterable = iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
            {
                this.codeAttr$1 = codeAttr$1;
                this.codeAttrField$1 = codeAttrField$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        return BoxesRunTime.unboxToInt((Object)codeSizes.max((Ordering)Ordering.Int$.MODULE$));
    }

    private LoadingCache<CodeAndComment, Tuple2<GeneratedClass, Object>> cache() {
        return this.cache;
    }

    private CodeGenerator$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<CodeAndComment, Tuple2<GeneratedClass, Object>>(){

            public Tuple2<GeneratedClass, Object> load(CodeAndComment code) {
                long startTime = System.nanoTime();
                Tuple2<GeneratedClass, Object> result = CodeGenerator$.MODULE$.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$doCompile(code);
                long endTime = System.nanoTime();
                CodegenMetrics$.MODULE$.METRIC_SOURCE_CODE_SIZE().update(code.body().length());
                CodegenMetrics$.MODULE$.METRIC_COMPILATION_TIME().update((long)this.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anon$$timeMs$1(startTime, endTime));
                CodeGenerator$.MODULE$.logInfo((Function0<String>)new Serializable(this, startTime, endTime){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final long startTime$1;
                    private final long endTime$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code generated in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anon$$timeMs$1(this.startTime$1, this.endTime$1))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.startTime$1 = startTime$1;
                        this.endTime$1 = endTime$1;
                    }
                });
                return result;
            }

            public final double org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anon$$timeMs$1(long startTime$1, long endTime$1) {
                return (double)(endTime$1 - startTime$1) / (double)1000000;
            }
        });
    }
}

