/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata20.repository.query;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.springdata20.repository.query.IgniteQuery;
import org.apache.ignite.springdata20.repository.query.IgniteQueryGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;

public class IgniteRepositoryQuery
implements RepositoryQuery {
    private final Class<?> type;
    private final IgniteQuery qry;
    private final IgniteCache cache;
    private final Method mtd;
    private final RepositoryMetadata metadata;
    private final ProjectionFactory factory;
    private final ReturnStrategy returnStgy;

    public IgniteRepositoryQuery(RepositoryMetadata metadata, IgniteQuery qry, Method mtd, ProjectionFactory factory, IgniteCache cache) {
        this.type = metadata.getDomainType();
        this.qry = qry;
        this.cache = cache;
        this.metadata = metadata;
        this.mtd = mtd;
        this.factory = factory;
        this.returnStgy = this.calcReturnType(mtd, qry.isFieldQuery());
    }

    public Object execute(Object[] prmtrs) {
        Query qry = this.prepareQuery(prmtrs);
        QueryCursor qryCursor = this.cache.query(qry);
        return this.transformQueryCursor(prmtrs, qryCursor);
    }

    public QueryMethod getQueryMethod() {
        return new QueryMethod(this.mtd, this.metadata, this.factory);
    }

    private ReturnStrategy calcReturnType(Method mtd, boolean isFieldQry) {
        Class<ArrayList> returnType = mtd.getReturnType();
        if (returnType.isAssignableFrom(ArrayList.class)) {
            if (isFieldQry) {
                if (this.hasAssignableGenericReturnTypeFrom(ArrayList.class, mtd)) {
                    return ReturnStrategy.LIST_OF_LISTS;
                }
            } else if (this.hasAssignableGenericReturnTypeFrom(Cache.Entry.class, mtd)) {
                return ReturnStrategy.LIST_OF_CACHE_ENTRIES;
            }
            return ReturnStrategy.LIST_OF_VALUES;
        }
        if (returnType == Slice.class) {
            if (isFieldQry) {
                if (this.hasAssignableGenericReturnTypeFrom(ArrayList.class, mtd)) {
                    return ReturnStrategy.SLICE_OF_LISTS;
                }
            } else if (this.hasAssignableGenericReturnTypeFrom(Cache.Entry.class, mtd)) {
                return ReturnStrategy.SLICE_OF_CACHE_ENTRIES;
            }
            return ReturnStrategy.SLICE_OF_VALUES;
        }
        if (Cache.Entry.class.isAssignableFrom(returnType)) {
            return ReturnStrategy.CACHE_ENTRY;
        }
        return ReturnStrategy.ONE_VALUE;
    }

    private boolean hasAssignableGenericReturnTypeFrom(Class<?> cls, Method mtd) {
        Type[] actualTypeArguments = ((ParameterizedType)mtd.getGenericReturnType()).getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            return false;
        }
        if (actualTypeArguments[0] instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)actualTypeArguments[0];
            Class type1 = (Class)type.getRawType();
            return type1.isAssignableFrom(cls);
        }
        if (actualTypeArguments[0] instanceof Class) {
            Class typeArg = (Class)actualTypeArguments[0];
            return typeArg.isAssignableFrom(cls);
        }
        return false;
    }

    @Nullable
    private Object transformQueryCursor(Object[] prmtrs, QueryCursor qryCursor) {
        if (this.qry.isFieldQuery()) {
            QueryCursor qryIter = qryCursor;
            switch (this.returnStgy) {
                case LIST_OF_VALUES: {
                    ArrayList list = new ArrayList();
                    for (List entry : qryIter) {
                        list.add(entry.get(0));
                    }
                    return list;
                }
                case ONE_VALUE: {
                    Iterator iter = qryIter.iterator();
                    if (iter.hasNext()) {
                        return ((List)iter.next()).get(0);
                    }
                    return null;
                }
                case SLICE_OF_VALUES: {
                    ArrayList content = new ArrayList();
                    for (List entry : qryIter) {
                        content.add(entry.get(0));
                    }
                    return new SliceImpl(content, (Pageable)prmtrs[prmtrs.length - 1], true);
                }
                case SLICE_OF_LISTS: {
                    return new SliceImpl(qryCursor.getAll(), (Pageable)prmtrs[prmtrs.length - 1], true);
                }
                case LIST_OF_LISTS: {
                    return qryCursor.getAll();
                }
            }
            throw new IllegalStateException();
        }
        QueryCursor qryIter = qryCursor;
        switch (this.returnStgy) {
            case LIST_OF_VALUES: {
                ArrayList<Object> list = new ArrayList<Object>();
                for (CacheEntryImpl entry : qryIter) {
                    list.add(entry.getValue());
                }
                return list;
            }
            case ONE_VALUE: {
                Iterator iter1 = qryIter.iterator();
                if (iter1.hasNext()) {
                    return ((CacheEntryImpl)iter1.next()).getValue();
                }
                return null;
            }
            case CACHE_ENTRY: {
                Iterator iter2 = qryIter.iterator();
                if (iter2.hasNext()) {
                    return iter2.next();
                }
                return null;
            }
            case SLICE_OF_VALUES: {
                ArrayList<Object> content = new ArrayList<Object>();
                for (CacheEntryImpl entry : qryIter) {
                    content.add(entry.getValue());
                }
                return new SliceImpl(content, (Pageable)prmtrs[prmtrs.length - 1], true);
            }
            case SLICE_OF_CACHE_ENTRIES: {
                return new SliceImpl(qryCursor.getAll(), (Pageable)prmtrs[prmtrs.length - 1], true);
            }
            case LIST_OF_CACHE_ENTRIES: {
                return qryCursor.getAll();
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    private Query prepareQuery(Object[] prmtrs) {
        SqlFieldsQuery query;
        Object[] parameters = prmtrs;
        String sql = this.qry.sql();
        switch (this.qry.options()) {
            case SORTING: {
                sql = IgniteQueryGenerator.addSorting(new StringBuilder(sql), (Sort)parameters[parameters.length - 1]).toString();
                parameters = Arrays.copyOfRange(parameters, 0, parameters.length - 1);
                break;
            }
            case PAGINATION: {
                sql = IgniteQueryGenerator.addPaging(new StringBuilder(sql), (Pageable)parameters[parameters.length - 1]).toString();
                parameters = Arrays.copyOfRange(parameters, 0, parameters.length - 1);
            }
        }
        if (this.qry.isFieldQuery()) {
            SqlFieldsQuery sqlFieldsQry = new SqlFieldsQuery(sql);
            sqlFieldsQry.setArgs(parameters);
            query = sqlFieldsQry;
        } else {
            SqlQuery sqlQry = new SqlQuery(this.type, sql);
            sqlQry.setArgs(parameters);
            query = sqlQry;
        }
        return query;
    }

    private static enum ReturnStrategy {
        ONE_VALUE,
        CACHE_ENTRY,
        LIST_OF_CACHE_ENTRIES,
        LIST_OF_VALUES,
        LIST_OF_LISTS,
        SLICE_OF_VALUES,
        SLICE_OF_CACHE_ENTRIES,
        SLICE_OF_LISTS;

    }
}

