/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.websession;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.ignite.cache.websession.WebSessionFilter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

class WebSession
implements HttpSession,
Externalizable {
    private static final long serialVersionUID = 0L;
    private volatile transient boolean isValid = true;
    private static final HttpSessionContext EMPTY_SES_CTX = new HttpSessionContext(){

        @Nullable
        public HttpSession getSession(String id) {
            return null;
        }

        public Enumeration<String> getIds() {
            return Collections.enumeration(Collections.emptyList());
        }
    };
    private String id;
    private long createTime;
    private long accessTime;
    private int maxInactiveInterval;
    @GridToStringInclude
    private Map<String, Object> attrs;
    @GridToStringExclude
    private transient ServletContext ctx;
    @GridToStringExclude
    private transient WebSessionFilter filter;
    private transient boolean isNew;
    private transient Collection<T2<String, Object>> updates;
    private transient HttpSession genSes;

    public WebSession() {
    }

    WebSession(String id, HttpSession ses) {
        assert (id != null);
        assert (ses != null);
        this.id = id;
        this.createTime = ses.getCreationTime();
        this.accessTime = ses.getLastAccessedTime();
        this.maxInactiveInterval = ses.getMaxInactiveInterval();
        this.isNew = ses.isNew();
        this.attrs = new HashMap<String, Object>();
        Enumeration names = ses.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.attrs.put(name, ses.getAttribute(name));
        }
    }

    WebSession(String id, HttpSession ses, boolean isNew) {
        this(id, ses);
        this.isNew = isNew;
    }

    protected void genSes(HttpSession genSes) {
        this.genSes = genSes;
    }

    public void servletContext(ServletContext ctx) {
        assert (ctx != null);
        this.ctx = ctx;
    }

    public void filter(WebSessionFilter filter) {
        assert (filter != null);
        this.filter = filter;
    }

    protected boolean isValid() {
        return this.isValid;
    }

    public void resetUpdates() {
        this.updates = new LinkedList<T2<String, Object>>();
    }

    public Collection<T2<String, Object>> updates() {
        Collection<T2<String, Object>> updates0 = this.updates;
        this.updates = null;
        return updates0;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public ServletContext getServletContext() {
        return this.ctx;
    }

    public long getCreationTime() {
        if (!this.isValid) {
            throw new IllegalStateException("Call on invalidated session!");
        }
        return this.createTime;
    }

    public long getLastAccessedTime() {
        if (!this.isValid) {
            throw new IllegalStateException("Call on invalidated session!");
        }
        return this.accessTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public Object getAttribute(String name) {
        if (!this.isValid) {
            throw new IllegalStateException("Call on invalidated session!");
        }
        Object val = this.attrs.get(name);
        if (val != null && this.updates != null) {
            this.updates.add((T2<String, Object>)new T2((Object)name, val));
        }
        return val;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (!this.isValid) {
            throw new IllegalStateException("Call on invalidated session!");
        }
        return Collections.enumeration(this.attrs.keySet());
    }

    public String[] getValueNames() {
        if (!this.isValid) {
            throw new IllegalStateException("Call on invalidated session!");
        }
        return this.attrs.keySet().toArray(new String[this.attrs.size()]);
    }

    public void setAttribute(String name, Object val) {
        if (!this.isValid) {
            throw new IllegalStateException("Call on invalidated session!");
        }
        this.attrs.put(name, val);
        if (this.updates != null) {
            this.updates.add((T2<String, Object>)new T2((Object)name, val));
        }
    }

    public void putValue(String name, Object val) {
        this.setAttribute(name, val);
    }

    public void removeAttribute(String name) {
        if (!this.isValid) {
            throw new IllegalStateException("Call on invalidated session!");
        }
        this.attrs.remove(name);
        if (this.updates != null) {
            this.updates.add((T2<String, Object>)new T2((Object)name, null));
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        if (!this.isValid) {
            throw new IllegalStateException("Call on invalidated session!");
        }
        this.attrs.clear();
        this.updates = null;
        this.filter.destroySession(this.id);
        this.genSes.invalidate();
        this.isValid = false;
    }

    public boolean isNew() {
        if (!this.isValid) {
            throw new IllegalStateException("Call on invalidated session!");
        }
        return this.isNew;
    }

    public HttpSessionContext getSessionContext() {
        return EMPTY_SES_CTX;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString((DataOutput)out, (String)this.id);
        out.writeLong(this.createTime);
        out.writeLong(this.accessTime);
        out.writeInt(this.maxInactiveInterval);
        U.writeMap((ObjectOutput)out, this.attrs);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readString((DataInput)in);
        this.createTime = in.readLong();
        this.accessTime = in.readLong();
        this.maxInactiveInterval = in.readInt();
        this.attrs = U.readMap((ObjectInput)in);
    }

    public String toString() {
        return S.toString(WebSession.class, (Object)this);
    }
}

