/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.ignite.cache.store.cassandra.serializer.Serializer;
import org.apache.ignite.internal.util.typedef.internal.U;

public class KryoSerializer
implements Serializer {
    private static final long serialVersionUID = 0L;
    private static final int DFLT_BUFFER_SIZE = 4096;
    private transient ThreadLocal<Kryo> kryos = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            return new Kryo();
        }
    };

    public ByteBuffer serialize(Object object) {
        ByteBuffer byteBuffer;
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        Output output = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream(4096);
            output = new Output((OutputStream)byteArrayOutputStream);
            this.kryos.get().writeClassAndObject(output, object);
            output.flush();
            byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                throw new IllegalStateException("Failed to serialize object of the class '" + object.getClass().getName() + "'", throwable);
            }
            catch (Throwable throwable2) {
                U.closeQuiet(output);
                U.closeQuiet((AutoCloseable)byteArrayOutputStream);
                throw throwable2;
            }
        }
        U.closeQuiet((AutoCloseable)output);
        U.closeQuiet((AutoCloseable)byteArrayOutputStream);
        return byteBuffer;
    }

    public Object deserialize(ByteBuffer byteBuffer) {
        Object object;
        ByteArrayInputStream byteArrayInputStream = null;
        Input input = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byteBuffer.array());
            input = new Input((InputStream)byteArrayInputStream);
            object = this.kryos.get().readClassAndObject(input);
        }
        catch (Throwable throwable) {
            try {
                throw new IllegalStateException("Failed to deserialize object from byte stream", throwable);
            }
            catch (Throwable throwable2) {
                U.closeQuiet(input);
                U.closeQuiet((AutoCloseable)byteArrayInputStream);
                throw throwable2;
            }
        }
        U.closeQuiet((AutoCloseable)input);
        U.closeQuiet((AutoCloseable)byteArrayInputStream);
        return object;
    }
}

