/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.twitter4j.parser;

import com.google.common.primitives.Longs;
import com.twitter.hbc.twitter4j.message.DisconnectMessage;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.JSONObjectType;
import twitter4j.StatusDeletionNotice;

public class JSONObjectParser {
    public static StatusDeletionNotice parseStatusDelete(JSONObject json) throws JSONException {
        JSONObject statusDelete = json.getJSONObject("delete").getJSONObject("status");
        final long statusId = statusDelete.getLong("id");
        final long userId = statusDelete.getLong("user_id");
        return new StatusDeletionNotice(){

            public long getStatusId() {
                return statusId;
            }

            public long getUserId() {
                return userId;
            }

            public int compareTo(StatusDeletionNotice o) {
                return Longs.compare((long)this.getStatusId(), (long)o.getStatusId());
            }
        };
    }

    public static int parseTrackLimit(JSONObject json) throws JSONException {
        return json.getJSONObject("limit").getInt("track");
    }

    public static JSONObject parseEventSource(JSONObject json) throws JSONException {
        return json.getJSONObject("source");
    }

    public static JSONObject parseEventTarget(JSONObject json) throws JSONException {
        return json.getJSONObject("target");
    }

    public static JSONObject parseEventTargetObject(JSONObject json) throws JSONException {
        return json.getJSONObject("target_object");
    }

    public static long[] parseFriendList(JSONObject json) throws JSONException {
        JSONArray friends = json.getJSONArray("friends");
        long[] friendIds = new long[friends.length()];
        for (int i = 0; i < friendIds.length; ++i) {
            friendIds[i] = friends.getLong(i);
        }
        return friendIds;
    }

    public static boolean hasSitestreamUser(JSONObject envelope) {
        return envelope.has("for_user");
    }

    public static long getSitestreamUser(JSONObject envelope) throws JSONException {
        return envelope.getLong("for_user");
    }

    public static boolean hasSitestreamMessage(JSONObject envelope) {
        return envelope.has("message");
    }

    public static JSONObject getSitestreamMessage(JSONObject envelope) throws JSONException {
        return envelope.getJSONObject("message");
    }

    public static boolean isControlStreamMessage(JSONObject message) throws JSONException {
        return message.has("control");
    }

    public static String getStreamId(JSONObject message) throws JSONException {
        String uri = message.getJSONObject("control").getString("control_uri");
        String[] split = uri.split("/");
        if (split.length != 5) {
            throw new IllegalStateException("Unknown url format: " + uri);
        }
        return split[split.length - 1];
    }

    @Deprecated
    public static boolean isDisconnectMessage(JSONObject message) {
        return JSONObjectType.determine((JSONObject)message) == JSONObjectType.Type.DISCONNECTION;
    }

    public static boolean isRetweetMessage(JSONObject message) throws JSONException {
        Object event = message.opt("event");
        if (!(event instanceof String)) {
            return false;
        }
        return "retweet".equals(event);
    }

    public static DisconnectMessage parseDisconnectMessage(JSONObject message) throws JSONException {
        JSONObject json = message.getJSONObject("disconnect");
        int code = json.getInt("code");
        String streamName = json.getString("stream_name");
        String reason = json.getString("reason");
        return new DisconnectMessage(code, streamName, reason);
    }
}

