/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rdd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.ReliableCheckpointRDD;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

public final class ReliableCheckpointRDD$
implements Logging,
Serializable {
    public static final ReliableCheckpointRDD$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ReliableCheckpointRDD$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    public String org$apache$spark$rdd$ReliableCheckpointRDD$$checkpointFileName(int partitionIndex) {
        return new StringOps(Predef$.MODULE$.augmentString("part-%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionIndex)}));
    }

    private String checkpointPartitionerFileName() {
        return "_partitioner";
    }

    /*
     * WARNING - void declaration
     */
    public <T> ReliableCheckpointRDD<T> writeRDDToCheckpointDirectory(RDD<T> originalRDD, String checkpointDir, int blockSize, ClassTag<T> evidence$2) {
        void var8_7;
        long checkpointStartTimeNs = System.nanoTime();
        Path checkpointDirPath = new Path(checkpointDir);
        SparkContext sc = originalRDD.sparkContext();
        FileSystem fs = checkpointDirPath.getFileSystem(sc.hadoopConfiguration());
        if (fs.mkdirs(checkpointDirPath)) {
            Broadcast<SerializableConfiguration> broadcastedConf = sc.broadcast(new SerializableConfiguration(sc.hadoopConfiguration()), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
            String string = checkpointDirPath.toString();
            int n = this.writePartitionToCheckpointFile$default$3();
            sc.runJob(originalRDD, new Serializable(evidence$2, broadcastedConf, string, n){
                public static final long serialVersionUID = 0L;
                private final ClassTag evidence$2$1;
                private final Broadcast broadcastedConf$1;
                private final String eta$0$1$1;
                private final int eta$1$1$1;

                public final void apply(TaskContext ctx, Iterator<T> iterator2) {
                    ReliableCheckpointRDD$.MODULE$.writePartitionToCheckpointFile(this.eta$0$1$1, this.broadcastedConf$1, this.eta$1$1$1, ctx, iterator2, this.evidence$2$1);
                }
                {
                    this.evidence$2$1 = evidence$2$1;
                    this.broadcastedConf$1 = broadcastedConf$1;
                    this.eta$0$1$1 = eta$0$1$1;
                    this.eta$1$1$1 = eta$1$1$1;
                }
            }, ClassTag$.MODULE$.Unit());
            if (originalRDD.partitioner().nonEmpty()) {
                this.writePartitionerToCheckpointDir(sc, (Partitioner)originalRDD.partitioner().get(), checkpointDirPath);
            }
            long checkpointDurationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - checkpointStartTimeNs);
            this.logInfo((Function0<String>)new Serializable(checkpointDurationMs){
                public static final long serialVersionUID = 0L;
                private final long checkpointDurationMs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpointing took ", " ms."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.checkpointDurationMs$1)}));
                }
                {
                    this.checkpointDurationMs$1 = checkpointDurationMs$1;
                }
            });
            ReliableCheckpointRDD<T> newRDD = new ReliableCheckpointRDD<T>(sc, checkpointDirPath.toString(), originalRDD.partitioner(), evidence$2);
            if (newRDD.partitions().length != originalRDD.partitions().length) {
                throw new SparkException(new StringBuilder().append((Object)"Checkpoint RDD has a different number of partitions from original RDD. Original ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RDD [ID: ", ", num of partitions: ", "]; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)originalRDD.id()), BoxesRunTime.boxToInteger((int)originalRDD.partitions().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint RDD [ID: ", ", num of partitions: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)newRDD.id())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)newRDD.partitions().length)}))).toString());
            }
            return newRDD;
        }
        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create checkpoint path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var8_7})));
    }

    public <T> int writeRDDToCheckpointDirectory$default$3() {
        return -1;
    }

    public <T> void writePartitionToCheckpointFile(String path, Broadcast<SerializableConfiguration> broadcastedConf, int blockSize, TaskContext ctx, Iterator<T> iterator2, ClassTag<T> evidence$3) {
        Path tempOutputPath;
        Path finalOutputPath;
        FileSystem fs;
        block7: {
            block6: {
                Object object;
                SparkEnv env = SparkEnv$.MODULE$.get();
                Path outputDir = new Path(path);
                fs = outputDir.getFileSystem(broadcastedConf.value().value());
                String finalOutputName = this.org$apache$spark$rdd$ReliableCheckpointRDD$$checkpointFileName(ctx.partitionId());
                finalOutputPath = new Path(outputDir, finalOutputName);
                tempOutputPath = new Path(outputDir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", "-attempt-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{finalOutputName, BoxesRunTime.boxToInteger((int)ctx.attemptNumber())})));
                int bufferSize = env.conf().getInt("spark.buffer.size", 65536);
                if (blockSize < 0) {
                    FSDataOutputStream fileStream = fs.create(tempOutputPath, false, bufferSize);
                    object = BoxesRunTime.unboxToBoolean((Object)env.conf().get(package$.MODULE$.CHECKPOINT_COMPRESS())) ? CompressionCodec$.MODULE$.createCodec(env.conf()).compressedOutputStream((OutputStream)fileStream) : fileStream;
                } else {
                    object = fs.create(tempOutputPath, false, bufferSize, fs.getDefaultReplication(fs.getWorkingDirectory()), (long)blockSize);
                }
                FSDataOutputStream fileOutputStream = object;
                SerializerInstance serializer = env.serializer().newInstance();
                SerializationStream serializeStream = serializer.serializeStream((OutputStream)fileOutputStream);
                Utils$.MODULE$.tryWithSafeFinally(new Serializable(iterator2, evidence$3, serializeStream){
                    public static final long serialVersionUID = 0L;
                    private final Iterator iterator$1;
                    private final ClassTag evidence$3$1;
                    private final SerializationStream serializeStream$1;

                    public final SerializationStream apply() {
                        return this.serializeStream$1.writeAll(this.iterator$1, this.evidence$3$1);
                    }
                    {
                        this.iterator$1 = iterator$1;
                        this.evidence$3$1 = evidence$3$1;
                        this.serializeStream$1 = serializeStream$1;
                    }
                }, (Function0<BoxedUnit>)new Serializable(serializeStream){
                    public static final long serialVersionUID = 0L;
                    private final SerializationStream serializeStream$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.serializeStream$1.close();
                    }
                    {
                        this.serializeStream$1 = serializeStream$1;
                    }
                });
                if (fs.rename(tempOutputPath, finalOutputPath)) break block6;
                if (!fs.exists(finalOutputPath)) break block7;
                this.logInfo((Function0<String>)new Serializable(finalOutputPath){
                    public static final long serialVersionUID = 0L;
                    private final Path finalOutputPath$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Final output path ", " already exists; not overwriting it"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.finalOutputPath$1}));
                    }
                    {
                        this.finalOutputPath$1 = finalOutputPath$1;
                    }
                });
                if (!fs.delete(tempOutputPath, false)) {
                    this.logWarning((Function0<String>)new Serializable(tempOutputPath){
                        public static final long serialVersionUID = 0L;
                        private final Path tempOutputPath$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempOutputPath$1}));
                        }
                        {
                            this.tempOutputPath$1 = tempOutputPath$1;
                        }
                    });
                }
            }
            return;
        }
        this.logInfo((Function0<String>)new Serializable(tempOutputPath){
            public static final long serialVersionUID = 0L;
            private final Path tempOutputPath$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting tempOutputPath ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempOutputPath$1}));
            }
            {
                this.tempOutputPath$1 = tempOutputPath$1;
            }
        });
        fs.delete(tempOutputPath, false);
        throw new IOException(new StringBuilder().append((Object)"Checkpoint failed: failed to save output of task: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and final output path does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ctx.attemptNumber()), finalOutputPath}))).toString());
    }

    public <T> int writePartitionToCheckpointFile$default$3() {
        return -1;
    }

    private void writePartitionerToCheckpointDir(SparkContext sc, Partitioner partitioner, Path checkpointDirPath) {
        try {
            Path partitionerFilePath = new Path(checkpointDirPath, this.checkpointPartitionerFileName());
            int bufferSize = sc.conf().getInt("spark.buffer.size", 65536);
            FileSystem fs = partitionerFilePath.getFileSystem(sc.hadoopConfiguration());
            FSDataOutputStream fileOutputStream = fs.create(partitionerFilePath, false, bufferSize);
            SerializerInstance serializer = SparkEnv$.MODULE$.get().serializer().newInstance();
            SerializationStream serializeStream = serializer.serializeStream((OutputStream)fileOutputStream);
            Utils$.MODULE$.tryWithSafeFinally(new Serializable(partitioner, serializeStream){
                public static final long serialVersionUID = 0L;
                private final Partitioner partitioner$1;
                private final SerializationStream serializeStream$2;

                public final SerializationStream apply() {
                    return this.serializeStream$2.writeObject(this.partitioner$1, ClassTag$.MODULE$.apply(Partitioner.class));
                }
                {
                    this.partitioner$1 = partitioner$1;
                    this.serializeStream$2 = serializeStream$2;
                }
            }, (Function0<BoxedUnit>)new Serializable(serializeStream){
                public static final long serialVersionUID = 0L;
                private final SerializationStream serializeStream$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.serializeStream$2.close();
                }
                {
                    this.serializeStream$2 = serializeStream$2;
                }
            });
            this.logDebug((Function0<String>)new Serializable(partitionerFilePath){
                public static final long serialVersionUID = 0L;
                private final Path partitionerFilePath$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Written partitioner to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionerFilePath$1}));
                }
                {
                    this.partitionerFilePath$1 = partitionerFilePath$1;
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            this.logWarning((Function0<String>)new Serializable(partitioner, checkpointDirPath){
                public static final long serialVersionUID = 0L;
                private final Partitioner partitioner$1;
                private final Path checkpointDirPath$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error writing partitioner ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitioner$1, this.checkpointDirPath$2}));
                }
                {
                    this.partitioner$1 = partitioner$1;
                    this.checkpointDirPath$2 = checkpointDirPath$2;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Option<Partitioner> org$apache$spark$rdd$ReliableCheckpointRDD$$readCheckpointedPartitionerFile(SparkContext sc, String checkpointDirPath) {
        None$ none$;
        try {
            int bufferSize = sc.conf().getInt("spark.buffer.size", 65536);
            Path partitionerFilePath = new Path(checkpointDirPath, this.checkpointPartitionerFileName());
            FileSystem fs = partitionerFilePath.getFileSystem(sc.hadoopConfiguration());
            FSDataInputStream fileInputStream = fs.open(partitionerFilePath, bufferSize);
            SerializerInstance serializer = SparkEnv$.MODULE$.get().serializer().newInstance();
            Partitioner partitioner = (Partitioner)Utils$.MODULE$.tryWithSafeFinally(new Serializable(fileInputStream, serializer){
                public static final long serialVersionUID = 0L;
                private final FSDataInputStream fileInputStream$1;
                private final SerializerInstance serializer$1;

                public final Partitioner apply() {
                    DeserializationStream deserializeStream = this.serializer$1.deserializeStream((InputStream)this.fileInputStream$1);
                    return (Partitioner)Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, deserializeStream){
                        public static final long serialVersionUID = 0L;
                        private final DeserializationStream deserializeStream$1;

                        public final Partitioner apply() {
                            return (Partitioner)this.deserializeStream$1.readObject(ClassTag$.MODULE$.apply(Partitioner.class));
                        }
                        {
                            this.deserializeStream$1 = deserializeStream$1;
                        }
                    }, (Function0<BoxedUnit>)new Serializable(this, deserializeStream){
                        public static final long serialVersionUID = 0L;
                        private final DeserializationStream deserializeStream$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.deserializeStream$1.close();
                        }
                        {
                            this.deserializeStream$1 = deserializeStream$1;
                        }
                    });
                }
                {
                    this.fileInputStream$1 = fileInputStream$1;
                    this.serializer$1 = serializer$1;
                }
            }, (Function0<BoxedUnit>)new Serializable(fileInputStream){
                public static final long serialVersionUID = 0L;
                private final FSDataInputStream fileInputStream$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.fileInputStream$1.close();
                }
                {
                    this.fileInputStream$1 = fileInputStream$1;
                }
            });
            this.logDebug((Function0<String>)new Serializable(partitionerFilePath){
                public static final long serialVersionUID = 0L;
                private final Path partitionerFilePath$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read partitioner from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionerFilePath$2}));
                }
                {
                    this.partitionerFilePath$2 = partitionerFilePath$2;
                }
            });
            none$ = new Some((Object)partitioner);
        }
        catch (Throwable throwable) {
            None$ none$2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FileNotFoundException) {
                FileNotFoundException fileNotFoundException = (FileNotFoundException)throwable2;
                this.logDebug((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No partitioner file";
                    }
                }, fileNotFoundException);
                none$2 = None$.MODULE$;
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)new Serializable(checkpointDirPath){
                    public static final long serialVersionUID = 0L;
                    private final String checkpointDirPath$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading partitioner from ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpointDirPath$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitioner will not be recovered which may lead to performance loss"})).s((Seq)Nil$.MODULE$)).toString();
                    }
                    {
                        this.checkpointDirPath$1 = checkpointDirPath$1;
                    }
                }, e);
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        return none$;
    }

    public <T> Iterator<T> readCheckpointFile(Path path, Broadcast<SerializableConfiguration> broadcastedConf, TaskContext context) {
        SparkEnv env = SparkEnv$.MODULE$.get();
        FileSystem fs = path.getFileSystem(broadcastedConf.value().value());
        int bufferSize = env.conf().getInt("spark.buffer.size", 65536);
        FSDataInputStream fileStream = fs.open(path, bufferSize);
        FSDataInputStream fileInputStream = BoxesRunTime.unboxToBoolean((Object)env.conf().get(package$.MODULE$.CHECKPOINT_COMPRESS())) ? CompressionCodec$.MODULE$.createCodec(env.conf()).compressedInputStream((InputStream)fileStream) : fileStream;
        SerializerInstance serializer = env.serializer().newInstance();
        DeserializationStream deserializeStream = serializer.deserializeStream((InputStream)fileInputStream);
        context.addTaskCompletionListener((Function1<TaskContext, BoxedUnit>)new Serializable(deserializeStream){
            public static final long serialVersionUID = 0L;
            private final DeserializationStream deserializeStream$2;

            public final void apply(TaskContext context) {
                this.deserializeStream$2.close();
            }
            {
                this.deserializeStream$2 = deserializeStream$2;
            }
        });
        return deserializeStream.asIterator();
    }

    public <T> Option<Partitioner> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ReliableCheckpointRDD$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

