/*
 * Decompiled with CFR 0.152.
 */
package deepwater.datasets;

import deepwater.datasets.ImageDataSet;
import deepwater.datasets.Pair;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CIFAR10ImageDataset
extends ImageDataSet {
    public CIFAR10ImageDataset() {
        super(32, 32, 3, 10);
    }

    @Override
    public List<Pair<Integer, float[]>> loadImages(String ... filepath) throws IOException {
        ArrayList<Pair<Integer, float[]>> images = new ArrayList<Pair<Integer, float[]>>();
        for (String path : filepath) {
            FileInputStream inputStream = new FileInputStream(path);
            byte[] buffer = new byte[3073];
            while (((InputStream)inputStream).read(buffer, 0, buffer.length) != -1) {
                int label = buffer[0] % 255;
                float[][] imageDataFloat = new float[3][1024];
                int i = 1;
                for (int channel = 0; channel < 3; ++channel) {
                    for (int j = 0; j < 1024; ++j) {
                        float result;
                        imageDataFloat[channel][j] = result = (float)(buffer[i++] & 0xFF);
                    }
                }
                assert (i == 3073);
                float[] result = new float[3072];
                int k = 0;
                for (int j = 0; j < 1024; ++j) {
                    for (int channel = 0; channel < 3; ++channel) {
                        result[k++] = imageDataFloat[channel][j];
                    }
                }
                assert (k == 3072);
                images.add(new Pair<Integer, float[]>(label, result));
            }
        }
        return images;
    }
}

