/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.h2o;

import hex.genmodel.CategoricalEncoding;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.MojoReaderBackendFactory;
import hex.genmodel.easy.EasyPredictModelWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ignite.ml.h2o.H2OMojoModel;
import org.apache.ignite.ml.inference.parser.ModelParser;
import org.apache.ignite.ml.math.primitives.vector.NamedVector;

public class H2OMojoModelParser
implements ModelParser<NamedVector, Double, H2OMojoModel> {
    private static final long serialVersionUID = -170352744966205716L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public H2OMojoModel parse(byte[] mojoBytes) {
        try (ByteArrayInputStream mojoInputStream = new ByteArrayInputStream(mojoBytes);){
            MojoReaderBackend readerBackend = MojoReaderBackendFactory.createReaderBackend((InputStream)mojoInputStream, (MojoReaderBackendFactory.CachingStrategy)MojoReaderBackendFactory.CachingStrategy.MEMORY);
            MojoModel mojoMdl = MojoModel.load((MojoReaderBackend)readerBackend);
            this.validateMojoModel(mojoMdl);
            EasyPredictModelWrapper.Config cfg = new EasyPredictModelWrapper.Config().setUseExternalEncoding(true).setConvertInvalidNumbersToNa(true).setConvertUnknownCategoricalLevelsToNa(true).setModel((GenModel)mojoMdl);
            EasyPredictModelWrapper easyPredict = new EasyPredictModelWrapper(cfg);
            H2OMojoModel h2OMojoModel = new H2OMojoModel(easyPredict);
            return h2OMojoModel;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse MOJO", e);
        }
    }

    private void validateMojoModel(MojoModel mojoMdl) {
        switch (mojoMdl.getModelCategory()) {
            case Binomial: 
            case Multinomial: 
            case Ordinal: 
            case Regression: 
            case Clustering: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Model Category " + mojoMdl.getModelCategory() + " is not supported yet.");
            }
        }
        if (mojoMdl.getCategoricalEncoding() == CategoricalEncoding.OneHotExplicit) {
            return;
        }
        for (int i = 0; i < mojoMdl.nfeatures(); ++i) {
            if (mojoMdl.getDomainValues(i) == null) continue;
            String colName = mojoMdl.getNames()[i];
            throw new UnsupportedOperationException("Unsupported MOJO model: only models using trained using OneHotExplicit categorical encoding and models without categorical features are currently supported. Column `" + colName + "` is categorical.");
        }
    }
}

