/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class SystemViewLocal<R>
extends SqlAbstractLocalSystemView {
    private final SystemView<R> sysView;

    public SystemViewLocal(GridKernalContext ctx, SystemView<R> sysView) {
        super(SystemViewLocal.sqlName(sysView.name()), sysView.description(), ctx, SystemViewLocal.columnsList(sysView));
        this.sysView = sysView;
    }

    @Override
    public Iterator<Row> getRows(final Session ses, SearchRow first, SearchRow last) {
        final Iterator rows = this.sysView.iterator();
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return rows.hasNext();
            }

            @Override
            public Row next() {
                Object row = rows.next();
                Object[] data = new Value[SystemViewLocal.this.sysView.walker().count()];
                SystemViewLocal.this.sysView.walker().visitAll(row, new SystemViewRowAttributeWalker.AttributeWithValueVisitor((Value[])data){
                    final /* synthetic */ Value[] val$data;
                    {
                        this.val$data = valueArray;
                    }

                    public <T> void accept(int idx, String name, Class<T> clazz, T val) {
                        this.val$data[idx] = val == null ? ValueNull.INSTANCE : (clazz.isAssignableFrom(Class.class) ? ValueString.get((String)((Class)val).getName()) : (clazz.isAssignableFrom(String.class) || clazz.isEnum() || clazz.isAssignableFrom(IgniteUuid.class) || clazz.isAssignableFrom(InetSocketAddress.class) ? ValueString.get((String)Objects.toString(val)) : (clazz.isAssignableFrom(UUID.class) ? ValueUuid.get((UUID)((UUID)val)) : (clazz.isAssignableFrom(BigDecimal.class) ? ValueDecimal.get((BigDecimal)((BigDecimal)val)) : (clazz.isAssignableFrom(BigInteger.class) ? ValueDecimal.get((BigDecimal)new BigDecimal((BigInteger)val)) : (clazz.isAssignableFrom(Date.class) ? ValueTimestamp.fromMillis((long)((Date)val).getTime()) : (clazz.isAssignableFrom(Boolean.class) ? ValueBoolean.get((boolean)((Boolean)val)) : (clazz.isAssignableFrom(Byte.class) ? ValueByte.get((byte)((Byte)val)) : (clazz.isAssignableFrom(Character.class) ? ValueString.get((String)Objects.toString(val)) : (clazz.isAssignableFrom(Short.class) ? ValueShort.get((short)((Short)val)) : (clazz.isAssignableFrom(Integer.class) ? ValueInt.get((int)((Integer)val)) : (clazz.isAssignableFrom(Long.class) ? ValueLong.get((long)((Long)val)) : (clazz.isAssignableFrom(Float.class) ? ValueFloat.get((float)((Float)val).floatValue()) : (clazz.isAssignableFrom(Double.class) ? ValueDouble.get((double)((Double)val)) : ValueString.get((String)val.toString())))))))))))))));
                    }

                    public void acceptBoolean(int idx, String name, boolean val) {
                        this.val$data[idx] = ValueBoolean.get((boolean)val);
                    }

                    public void acceptChar(int idx, String name, char val) {
                        this.val$data[idx] = ValueString.get((String)Character.toString(val));
                    }

                    public void acceptByte(int idx, String name, byte val) {
                        this.val$data[idx] = ValueByte.get((byte)val);
                    }

                    public void acceptShort(int idx, String name, short val) {
                        this.val$data[idx] = ValueShort.get((short)val);
                    }

                    public void acceptInt(int idx, String name, int val) {
                        this.val$data[idx] = ValueInt.get((int)val);
                    }

                    public void acceptLong(int idx, String name, long val) {
                        this.val$data[idx] = ValueLong.get((long)val);
                    }

                    public void acceptFloat(int idx, String name, float val) {
                        this.val$data[idx] = ValueFloat.get((float)val);
                    }

                    public void acceptDouble(int idx, String name, double val) {
                        this.val$data[idx] = ValueDouble.get((double)val);
                    }
                });
                return SystemViewLocal.this.createRow(ses, data);
            }
        };
    }

    private static <R> Column[] columnsList(SystemView<R> sysView) {
        final Column[] cols = new Column[sysView.walker().count()];
        sysView.walker().visitAll(new SystemViewRowAttributeWalker.AttributeVisitor(){

            public <T> void accept(int idx, String name, Class<T> clazz) {
                int type = clazz.isAssignableFrom(String.class) || clazz.isEnum() || clazz.isAssignableFrom(IgniteUuid.class) || clazz.isAssignableFrom(Class.class) || clazz.isAssignableFrom(InetSocketAddress.class) ? 13 : (clazz.isAssignableFrom(UUID.class) ? 20 : (clazz.isAssignableFrom(BigDecimal.class) ? 6 : (clazz.isAssignableFrom(BigInteger.class) ? 6 : (clazz.isAssignableFrom(Date.class) ? 11 : (clazz == Boolean.TYPE || clazz.isAssignableFrom(Boolean.class) ? 1 : (clazz == Byte.TYPE || clazz.isAssignableFrom(Byte.class) ? 2 : (clazz == Character.TYPE || clazz.isAssignableFrom(Character.class) ? 13 : (clazz == Short.TYPE || clazz.isAssignableFrom(Short.class) ? 3 : (clazz == Integer.TYPE || clazz.isAssignableFrom(Integer.class) ? 4 : (clazz == Long.TYPE || clazz.isAssignableFrom(Long.class) ? 5 : (clazz == Float.TYPE || clazz.isAssignableFrom(Float.class) ? 8 : (clazz == Double.TYPE || clazz.isAssignableFrom(Double.class) ? 7 : 13))))))))))));
                cols[idx] = SystemViewLocal.newColumn(SystemViewLocal.sqlName(name), type);
            }
        });
        return cols;
    }

    @Override
    public long getRowCount() {
        return this.sysView.size();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    public static String sqlName(String name) {
        return name.replaceAll("([A-Z])", "_$1").replaceAll("\\.", "_").toUpperCase();
    }
}

