/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryResult;
import org.jetbrains.annotations.Nullable;

class MapQueryResults {
    private final IgniteH2Indexing h2;
    private final long qryReqId;
    private final AtomicReferenceArray<MapQueryResult> results;
    private final GridQueryCancel[] cancels;
    private final GridCacheContext<?, ?> cctx;
    private final boolean lazy;
    private volatile boolean cancelled;
    private final QueryContext qctx;

    MapQueryResults(IgniteH2Indexing h2, long qryReqId, int qrys, @Nullable GridCacheContext<?, ?> cctx, boolean lazy, QueryContext qctx) {
        this.h2 = h2;
        this.qryReqId = qryReqId;
        this.cctx = cctx;
        this.lazy = lazy;
        this.qctx = qctx;
        this.results = new AtomicReferenceArray(qrys);
        this.cancels = new GridQueryCancel[qrys];
        for (int i = 0; i < this.cancels.length; ++i) {
            this.cancels[i] = new GridQueryCancel();
        }
    }

    MapQueryResult result(int qry) {
        return this.results.get(qry);
    }

    GridQueryCancel queryCancel(int qryIdx) {
        return this.cancels[qryIdx];
    }

    void addResult(int qryIdx, MapQueryResult res) {
        if (!this.results.compareAndSet(qryIdx, null, res)) {
            throw new IllegalStateException();
        }
    }

    boolean isAllClosed() {
        for (int i = 0; i < this.results.length(); ++i) {
            MapQueryResult res = this.results.get(i);
            if (res != null && res.closed()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        MapQueryResults mapQueryResults = this;
        synchronized (mapQueryResults) {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            for (int i = 0; i < this.results.length(); ++i) {
                GridQueryCancel cancel = this.cancels[i];
                if (cancel == null) continue;
                cancel.cancel();
            }
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeResult(int idx) {
        MapQueryResult res = this.results.get(idx);
        if (res != null && !res.closed()) {
            try {
                res.lock();
                res.lockTables();
                MapQueryResults mapQueryResults = this;
                synchronized (mapQueryResults) {
                    res.close();
                    this.cancels[idx] = null;
                }
            }
            finally {
                res.unlock();
            }
        }
    }

    public void close() {
        for (int i = 0; i < this.results.length(); ++i) {
            this.closeResult(i);
        }
        if (this.lazy) {
            this.releaseQueryContext();
        }
    }

    boolean cancelled() {
        return this.cancelled;
    }

    long queryRequestId() {
        return this.qryReqId;
    }

    public QueryContext queryContext() {
        return this.qctx;
    }

    public void releaseQueryContext() {
        this.h2.queryContextRegistry().clearThreadLocal();
        if (this.qctx.distributedJoinContext() == null) {
            this.qctx.clearContext(false);
        }
    }

    public boolean isLazy() {
        return this.lazy;
    }
}

