/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.streaming.api.checkpoint.ExternallyInducedSource;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.FlinkException;

@Internal
public class SourceStreamTask<OUT, SRC extends SourceFunction<OUT>, OP extends StreamSource<OUT, SRC>>
extends StreamTask<OUT, OP> {
    private volatile boolean externallyInducedCheckpoints;

    public SourceStreamTask(Environment env) {
        super(env);
    }

    @Override
    protected void init() {
        SourceFunction source = (SourceFunction)((StreamSource)this.headOperator).getUserFunction();
        if (source instanceof ExternallyInducedSource) {
            this.externallyInducedCheckpoints = true;
            ExternallyInducedSource.CheckpointTrigger triggerHook = new ExternallyInducedSource.CheckpointTrigger(){

                @Override
                public void triggerCheckpoint(long checkpointId) throws FlinkException {
                    CheckpointOptions checkpointOptions = CheckpointOptions.forCheckpointWithDefaultLocation();
                    long timestamp = System.currentTimeMillis();
                    CheckpointMetaData checkpointMetaData = new CheckpointMetaData(checkpointId, timestamp);
                    try {
                        SourceStreamTask.super.triggerCheckpoint(checkpointMetaData, checkpointOptions);
                    }
                    catch (RuntimeException | FlinkException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new FlinkException(e.getMessage(), (Throwable)e);
                    }
                }
            };
            ((ExternallyInducedSource)source).setCheckpointTrigger(triggerHook);
        }
    }

    @Override
    protected void cleanup() {
    }

    @Override
    protected void run() throws Exception {
        ((StreamSource)this.headOperator).run(this.getCheckpointLock(), this.getStreamStatusMaintainer());
    }

    @Override
    protected void cancelTask() throws Exception {
        if (this.headOperator != null) {
            ((StreamSource)this.headOperator).cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean triggerCheckpoint(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions) throws Exception {
        if (!this.externallyInducedCheckpoints) {
            return super.triggerCheckpoint(checkpointMetaData, checkpointOptions);
        }
        Object object = this.getCheckpointLock();
        synchronized (object) {
            return this.isRunning();
        }
    }
}

