/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.cache.Loader;
import org.apache.ignite.yardstick.cache.model.SampleValue;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public abstract class IgniteCacheAbstractBenchmark<K, V>
extends IgniteAbstractBenchmark {
    protected IgniteCache<K, V> cache;
    protected List<IgniteCache> testCaches;
    private ThreadLocal<ThreadRange> threadRange = new ThreadLocal();
    private AtomicInteger threadIdx = new AtomicInteger();
    private int caches;
    private final AtomicInteger opCacheIdx = new AtomicInteger();
    private final ThreadLocal<IgniteCache<K, V>> opCache = new ThreadLocal();

    protected final IgniteCache<K, V> cacheForOperation() {
        return this.cacheForOperation(false);
    }

    protected final IgniteCache<K, V> cacheForOperation(boolean perThread) {
        if (this.caches > 1) {
            if (perThread) {
                IgniteCache cache = this.opCache.get();
                if (cache == null) {
                    cache = this.testCaches.get(this.opCacheIdx.getAndIncrement() % this.caches);
                    this.opCache.set(cache);
                    BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Initialized cache for thread [cache=" + cache.getName() + ']'));
                }
                return cache;
            }
            return this.testCaches.get(ThreadLocalRandom.current().nextInt(this.caches));
        }
        return this.cache;
    }

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.ignite().cluster().active(true);
        this.cache = this.cache();
        CacheConfiguration ccfg = (CacheConfiguration)this.cache.getConfiguration(CacheConfiguration.class);
        String grpName = ccfg.getGroupName();
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Benchmark setUp [name=" + ((Object)((Object)this)).getClass().getSimpleName() + ", cacheName=" + this.cache.getName() + ", cacheGroup=" + grpName + ", cacheCfg=" + this.cache.getConfiguration(CacheConfiguration.class) + ']'));
        this.caches = this.args.cachesCount();
        if (this.caches > 1) {
            ArrayList<CacheConfiguration> toCreate = new ArrayList<CacheConfiguration>();
            for (int i = 0; i < this.caches - 1; ++i) {
                JdkMarshaller marsh = new JdkMarshaller();
                CacheConfiguration ccfg0 = (CacheConfiguration)marsh.unmarshal(marsh.marshal((Object)ccfg), null);
                ccfg0.setName(this.cache.getName() + "-" + i);
                toCreate.add(ccfg0);
            }
            Collection caches = this.ignite().getOrCreateCaches(toCreate);
            this.testCaches = new ArrayList<IgniteCache>(caches);
            this.testCaches.add(this.cache);
            BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Created additional caches [caches=" + this.testCaches.size() + ", grp=" + grpName + ']'));
        }
        if (this.args.printPartitionStatistics()) {
            HashMap<ClusterNode, T2> parts = new HashMap<ClusterNode, T2>();
            for (ClusterNode node : this.ignite().cluster().nodes()) {
                parts.put(node, new T2(new ArrayList(), new ArrayList()));
            }
            U.sleep((long)5000L);
            Affinity aff = this.ignite().affinity(this.cache.getName());
            for (int p = 0; p < aff.partitions(); ++p) {
                Collection nodes = aff.mapPartitionToPrimaryAndBackups(p);
                boolean primary = true;
                for (ClusterNode node : nodes) {
                    if (primary) {
                        ((List)((T2)parts.get(node)).get1()).add(p);
                        primary = false;
                        continue;
                    }
                    ((List)((T2)parts.get(node)).get2()).add(p);
                }
            }
            BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Partition stats. [cacheName: " + this.cache.getName() + ", topVer: " + this.ignite().cluster().topologyVersion() + "]"));
            BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"(Node id,  Number of Primary, Percent, Number of Backup, Percent, Total, Percent)");
            for (Map.Entry e : parts.entrySet()) {
                List primary = (List)((T2)e.getValue()).get1();
                List backup = (List)((T2)e.getValue()).get2();
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)(((ClusterNode)e.getKey()).id() + "  " + primary.size() + "  " + (double)primary.size() * 1.0 / (double)aff.partitions() + "  " + backup.size() + "  " + (double)backup.size() * 1.0 / (double)(aff.partitions() * (this.args.backups() == 0 ? 1 : this.args.backups())) + "  " + (primary.size() + backup.size()) + "  " + ((double)primary.size() + (double)backup.size() * 1.0) / (double)(aff.partitions() * this.args.backups() + aff.partitions())));
            }
        }
        if (this.args.enablePreload()) {
            this.startPreloadLogging(this.args.preloadLogsInterval());
            this.preload();
            this.stopPreloadLogging();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preload() {
        IgniteSemaphore semaphore = this.ignite().semaphore("preloadSemaphore", 1, true, true);
        semaphore.acquire();
        try {
            IgniteCache preloadCache = this.ignite().getOrCreateCache("preloadCache");
            if (preloadCache.get((Object)"loaded") == null) {
                IgniteCompute compute = this.ignite().compute(this.ignite().cluster().forServers().forOldest());
                IgniteCache<K, V> cache = this.cacheForOperation();
                Integer res = (Integer)compute.apply((IgniteClosure)new Loader(cache, this.args, this.ignite()), (Object)0);
                preloadCache.put((Object)"loaded", (Object)res);
                if (res != null) {
                    this.args.setRange(res);
                }
            } else {
                BenchmarkUtils.println((String)("Setting range to " + preloadCache.get((Object)"loaded")));
                this.args.setRange((Integer)preloadCache.get((Object)"loaded"));
            }
        }
        finally {
            semaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void loadCachesData() throws Exception {
        List<IgniteCache> caches;
        List<Object> list = caches = this.testCaches != null ? this.testCaches : Collections.singletonList(this.cache);
        if (caches.size() > 1) {
            ExecutorService executor = Executors.newFixedThreadPool(10);
            try {
                ArrayList futs = new ArrayList();
                for (final IgniteCache igniteCache : caches) {
                    futs.add(executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            IgniteCacheAbstractBenchmark.this.loadCacheData0(igniteCache.getName());
                        }
                    }));
                }
                for (Future future : futs) {
                    future.get();
                }
            }
            finally {
                executor.shutdown();
            }
        } else {
            this.loadCacheData(caches.get(0).getName());
        }
    }

    protected final void loadSampleValues(String cacheName, int cnt) {
        try (IgniteDataStreamer dataLdr = this.ignite().dataStreamer(cacheName);){
            for (int i = 0; i < cnt; ++i) {
                dataLdr.addData((Object)i, (Object)new SampleValue(i));
                if (i % 100000 != 0) continue;
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                BenchmarkUtils.println((String)("Loaded entries [cache=" + cacheName + ", cnt=" + i + ']'));
            }
        }
        BenchmarkUtils.println((String)("Load entries done [cache=" + cacheName + ", cnt=" + cnt + ']'));
    }

    private void loadCacheData0(String cacheName) {
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Loading data for cache: " + cacheName));
        long start = System.nanoTime();
        this.loadCacheData(cacheName);
        long time = (System.nanoTime() - start) / 1000000L;
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Finished populating data [cache=" + cacheName + ", time=" + time + "ms]"));
    }

    protected void loadCacheData(String cacheName) {
        throw new IllegalStateException("Not implemented for " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    protected final ThreadRange threadRange() {
        ThreadRange r = this.threadRange.get();
        if (r == null) {
            if (this.args.keysPerThread()) {
                int idx = this.threadIdx.getAndIncrement();
                int keysPerThread = (int)((float)this.args.range() / (float)this.cfg.threads());
                int min = keysPerThread * idx;
                int max = min + keysPerThread;
                r = new ThreadRange(min, max);
            } else {
                r = new ThreadRange(0, this.args.range());
            }
            BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Initialized thread range [min=" + r.min + ", max=" + r.max + ']'));
            this.threadRange.set(r);
        }
        return r;
    }

    protected abstract IgniteCache<K, V> cache();

    static class ThreadRange {
        final int min;
        final int max;
        final ThreadLocalRandom rnd;

        private ThreadRange(int min, int max) {
            this.min = min;
            this.max = max;
            this.rnd = ThreadLocalRandom.current();
        }

        int nextRandom() {
            return this.rnd.nextInt(this.min, this.max);
        }
    }
}

