/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.concurrent.atomic.AtomicLong;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryUpdatedListener;
import org.apache.ignite.lang.IgniteAsyncCallback;
import org.apache.ignite.yardstick.cache.CacheEntryEventProbe;

public class CacheEntryEventAsyncProbe
extends CacheEntryEventProbe {
    @Override
    protected CacheEntryUpdatedListener<Integer, Integer> localListener(AtomicLong cntr) {
        return new CacheEntryEventListener(cntr);
    }

    @IgniteAsyncCallback
    private static final class CacheEntryEventListener
    implements CacheEntryUpdatedListener<Integer, Integer> {
        private AtomicLong cnt;

        public CacheEntryEventListener(AtomicLong cnt) {
            this.cnt = cnt;
        }

        public void onUpdated(Iterable<CacheEntryEvent<? extends Integer, ? extends Integer>> events) throws CacheEntryListenerException {
            int size = 0;
            for (CacheEntryEvent<? extends Integer, ? extends Integer> e : events) {
                ++size;
            }
            this.cnt.addAndGet(size);
        }
    }
}

