/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.xgboost.parser.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.ml.tree.DecisionTreeNode;
import org.apache.ignite.ml.xgboost.XGModelComposition;
import org.apache.ignite.ml.xgboost.parser.XGBoostModelBaseVisitor;
import org.apache.ignite.ml.xgboost.parser.XGBoostModelParser;
import org.apache.ignite.ml.xgboost.parser.visitor.XGTreeDictionaryVisitor;
import org.apache.ignite.ml.xgboost.parser.visitor.XGTreeVisitor;

public class XGModelVisitor
extends XGBoostModelBaseVisitor<XGModelComposition> {
    private final XGTreeDictionaryVisitor treeDictionaryVisitor = new XGTreeDictionaryVisitor();

    @Override
    public XGModelComposition visitXgModel(XGBoostModelParser.XgModelContext ctx) {
        ArrayList<DecisionTreeNode> trees = new ArrayList<DecisionTreeNode>();
        HashSet<String> featureNames = new HashSet<String>();
        for (XGBoostModelParser.XgTreeContext treeCtx : ctx.xgTree()) {
            featureNames.addAll((Collection<String>)this.treeDictionaryVisitor.visitXgTree(treeCtx));
        }
        Map<String, Integer> dict = this.buildDictionary(featureNames);
        XGTreeVisitor treeVisitor = new XGTreeVisitor(dict);
        for (XGBoostModelParser.XgTreeContext treeCtx : ctx.xgTree()) {
            DecisionTreeNode treeNode = treeVisitor.visitXgTree(treeCtx);
            trees.add(treeNode);
        }
        return new XGModelComposition(dict, trees);
    }

    private Map<String, Integer> buildDictionary(Set<String> featureNames) {
        ArrayList<String> orderedFeatureNames = new ArrayList<String>(featureNames);
        Collections.sort(orderedFeatureNames);
        HashMap<String, Integer> dict = new HashMap<String, Integer>();
        for (int i = 0; i < orderedFeatureNames.size(); ++i) {
            dict.put((String)orderedFeatureNames.get(i), i);
        }
        return dict;
    }
}

