/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.ml.dataset.primitive.FeatureMatrixWithLabelsOnHeapData;
import org.apache.ignite.ml.tree.TreeFilter;
import org.apache.ignite.ml.tree.data.TreeDataIndex;

public class DecisionTreeData
extends FeatureMatrixWithLabelsOnHeapData {
    private double[] copiedOriginalLabels;
    private final List<TreeDataIndex> indexesCache;
    private final boolean buildIdx;

    public DecisionTreeData(double[][] features, double[] labels, boolean buildIdx) {
        super(features, labels);
        this.buildIdx = buildIdx;
        this.indexesCache = new ArrayList<TreeDataIndex>();
        if (buildIdx) {
            this.indexesCache.add(new TreeDataIndex(features, labels));
        }
    }

    public DecisionTreeData filter(TreeFilter filter) {
        int size = 0;
        double[][] features = this.getFeatures();
        double[] labels = this.getLabels();
        for (int i = 0; i < features.length; ++i) {
            if (!filter.test(features[i])) continue;
            ++size;
        }
        double[][] newFeatures = new double[size][];
        double[] newLabels = new double[size];
        int ptr = 0;
        for (int i = 0; i < features.length; ++i) {
            if (!filter.test(features[i])) continue;
            newFeatures[ptr] = features[i];
            newLabels[ptr] = labels[i];
            ++ptr;
        }
        return new DecisionTreeData(newFeatures, newLabels, this.buildIdx);
    }

    public void sort(int col) {
        this.sort(col, 0, this.getFeatures().length - 1);
    }

    private void sort(int col, int from, int to) {
        if (from < to) {
            double[][] features = this.getFeatures();
            double[] labels = this.getLabels();
            double pivot = features[(from + to) / 2][col];
            int i = from;
            int j = to;
            while (i <= j) {
                while (features[i][col] < pivot) {
                    ++i;
                }
                while (features[j][col] > pivot) {
                    --j;
                }
                if (i > j) continue;
                double[] tmpFeature = features[i];
                features[i] = features[j];
                features[j] = tmpFeature;
                double tmpLb = labels[i];
                labels[i] = labels[j];
                labels[j] = tmpLb;
                ++i;
                --j;
            }
            this.sort(col, from, j);
            this.sort(col, i, to);
        }
    }

    public double[] getCopiedOriginalLabels() {
        return this.copiedOriginalLabels;
    }

    public void setCopiedOriginalLabels(double[] copiedOriginalLabels) {
        this.copiedOriginalLabels = copiedOriginalLabels;
    }

    public TreeDataIndex createIndexByFilter(int depth, TreeFilter filter) {
        assert (depth >= 0 && depth <= this.indexesCache.size());
        if (depth > 0 && depth <= this.indexesCache.size() - 1) {
            for (int i = this.indexesCache.size() - 1; i >= depth; --i) {
                this.indexesCache.remove(i);
            }
        }
        if (depth == this.indexesCache.size()) {
            if (depth == 0) {
                this.indexesCache.add(new TreeDataIndex(this.getFeatures(), this.getLabels()));
            } else {
                TreeDataIndex lastIdx = this.indexesCache.get(depth - 1);
                this.indexesCache.add(lastIdx.filter(filter));
            }
        }
        return this.indexesCache.get(depth);
    }
}

