/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.minmaxscaling;

import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.PartitionContextBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;
import org.apache.ignite.ml.preprocessing.PreprocessingTrainer;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.preprocessing.minmaxscaling.MinMaxScalerPartitionData;
import org.apache.ignite.ml.preprocessing.minmaxscaling.MinMaxScalerPreprocessor;
import org.apache.ignite.ml.structures.LabeledVector;

public class MinMaxScalerTrainer<K, V>
implements PreprocessingTrainer<K, V> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MinMaxScalerPreprocessor<K, V> fit(LearningEnvironmentBuilder envBuilder, DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> basePreprocessor) {
        PartitionContextBuilder ctxBuilder = (env, upstream, upstreamSize) -> new EmptyContext();
        try (Dataset<EmptyContext, MinMaxScalerPartitionData> dataset = datasetBuilder.build(envBuilder, ctxBuilder, (env, upstream, upstreamSize, ctx) -> {
            double[] min = null;
            double[] max = null;
            while (upstream.hasNext()) {
                int i;
                UpstreamEntry entity = (UpstreamEntry)upstream.next();
                LabeledVector row = (LabeledVector)basePreprocessor.apply(entity.getKey(), entity.getValue());
                if (min == null) {
                    min = new double[row.size()];
                    for (i = 0; i < min.length; ++i) {
                        min[i] = Double.MAX_VALUE;
                    }
                } else assert (min.length == row.size()) : "Base preprocessor must return exactly " + min.length + " features";
                if (max == null) {
                    max = new double[row.size()];
                    for (i = 0; i < max.length; ++i) {
                        max[i] = -1.7976931348623157E308;
                    }
                } else assert (max.length == row.size()) : "Base preprocessor must return exactly " + min.length + " features";
                for (i = 0; i < row.size(); ++i) {
                    if (row.get(i) < min[i]) {
                        min[i] = row.get(i);
                    }
                    if (!(row.get(i) > max[i])) continue;
                    max[i] = row.get(i);
                }
            }
            return new MinMaxScalerPartitionData(min, max);
        }, this.learningEnvironment(basePreprocessor));){
            double[][] minMax = (double[][])dataset.compute(data -> {
                Object object;
                if (data.getMin() != null) {
                    double[][] dArrayArray = new double[2][];
                    dArrayArray[0] = data.getMin();
                    object = dArrayArray;
                    dArrayArray[1] = data.getMax();
                } else {
                    object = null;
                }
                return object;
            }, (a, b) -> {
                int i;
                if (a == null) {
                    return b;
                }
                if (b == null) {
                    return a;
                }
                double[][] res = new double[2][];
                res[0] = new double[a[0].length];
                for (i = 0; i < res[0].length; ++i) {
                    res[0][i] = Math.min(a[0][i], b[0][i]);
                }
                res[1] = new double[a[1].length];
                for (i = 0; i < res[1].length; ++i) {
                    res[1][i] = Math.max(a[1][i], b[1][i]);
                }
                return res;
            });
            MinMaxScalerPreprocessor<K, V> minMaxScalerPreprocessor = new MinMaxScalerPreprocessor<K, V>(minMax[0], minMax[1], basePreprocessor);
            return minMaxScalerPreprocessor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

