/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.imputing;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.PartitionContextBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.preprocessing.PreprocessingTrainer;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.preprocessing.imputing.ImputerPartitionData;
import org.apache.ignite.ml.preprocessing.imputing.ImputerPreprocessor;
import org.apache.ignite.ml.preprocessing.imputing.ImputingStrategy;
import org.apache.ignite.ml.structures.LabeledVector;

public class ImputerTrainer<K, V>
implements PreprocessingTrainer<K, V> {
    private ImputingStrategy imputingStgy = ImputingStrategy.MEAN;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImputerPreprocessor<K, V> fit(LearningEnvironmentBuilder envBuilder, DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> basePreprocessor) {
        PartitionContextBuilder builder = (env, upstream, upstreamSize) -> new EmptyContext();
        try (Dataset<EmptyContext, ImputerPartitionData> dataset = datasetBuilder.build(envBuilder, builder, (env, upstream, upstreamSize, ctx) -> {
            ImputerPartitionData partData;
            double[] sums = null;
            int[] counts = null;
            double[] maxs = null;
            double[] mins = null;
            Map<Double, Integer>[] valuesByFreq = null;
            block16: while (upstream.hasNext()) {
                UpstreamEntry entity = (UpstreamEntry)upstream.next();
                LabeledVector row = (LabeledVector)basePreprocessor.apply(entity.getKey(), entity.getValue());
                switch (this.imputingStgy) {
                    case MEAN: {
                        sums = this.updateTheSums(row, sums);
                        counts = this.updateTheCounts(row, counts);
                        continue block16;
                    }
                    case MOST_FREQUENT: {
                        valuesByFreq = this.updateFrequenciesByGivenRow(row, valuesByFreq);
                        continue block16;
                    }
                    case LEAST_FREQUENT: {
                        valuesByFreq = this.updateFrequenciesByGivenRow(row, valuesByFreq);
                        continue block16;
                    }
                    case MAX: {
                        maxs = this.updateTheMaxs(row, maxs);
                        continue block16;
                    }
                    case MIN: {
                        mins = this.updateTheMins(row, mins);
                        continue block16;
                    }
                    case COUNT: {
                        counts = this.updateTheCounts(row, counts);
                        continue block16;
                    }
                }
                throw new UnsupportedOperationException("The chosen strategy is not supported");
            }
            switch (this.imputingStgy) {
                case MEAN: {
                    partData = new ImputerPartitionData().withSums(sums).withCounts(counts);
                    break;
                }
                case MOST_FREQUENT: {
                    partData = new ImputerPartitionData().withValuesByFrequency(valuesByFreq);
                    break;
                }
                case LEAST_FREQUENT: {
                    partData = new ImputerPartitionData().withValuesByFrequency(valuesByFreq);
                    break;
                }
                case MAX: {
                    partData = new ImputerPartitionData().withMaxs(maxs);
                    break;
                }
                case MIN: {
                    partData = new ImputerPartitionData().withMins(mins);
                    break;
                }
                case COUNT: {
                    partData = new ImputerPartitionData().withCounts(counts);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("The chosen strategy is not supported");
                }
            }
            return partData;
        }, this.learningEnvironment(basePreprocessor));){
            Vector imputingValues;
            switch (this.imputingStgy) {
                case MEAN: {
                    imputingValues = VectorUtils.of(this.calculateImputingValuesBySumsAndCounts(dataset));
                    break;
                }
                case MOST_FREQUENT: {
                    imputingValues = VectorUtils.of(this.calculateImputingValuesByTheMostFrequentValues(dataset));
                    break;
                }
                case LEAST_FREQUENT: {
                    imputingValues = VectorUtils.of(this.calculateImputingValuesByTheLeastFrequentValues(dataset));
                    break;
                }
                case MAX: {
                    imputingValues = VectorUtils.of(this.calculateImputingValuesByMaxValues(dataset));
                    break;
                }
                case MIN: {
                    imputingValues = VectorUtils.of(this.calculateImputingValuesByMinValues(dataset));
                    break;
                }
                case COUNT: {
                    imputingValues = VectorUtils.of(this.calculateImputingValuesByCounts(dataset));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("The chosen strategy is not supported");
                }
            }
            ImputerPreprocessor<K, V> imputerPreprocessor = new ImputerPreprocessor<K, V>(imputingValues, basePreprocessor);
            return imputerPreprocessor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private double[] calculateImputingValuesByTheMostFrequentValues(Dataset<EmptyContext, ImputerPartitionData> dataset) {
        Map<Double, Integer>[] frequencies = this.getAggregatedFrequencies(dataset);
        double[] res = new double[frequencies.length];
        for (int i = 0; i < frequencies.length; ++i) {
            Optional<Map.Entry> max = frequencies[i].entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue));
            if (!max.isPresent()) continue;
            res[i] = (Double)max.get().getKey();
        }
        return res;
    }

    private double[] calculateImputingValuesByTheLeastFrequentValues(Dataset<EmptyContext, ImputerPartitionData> dataset) {
        Map<Double, Integer>[] frequencies = this.getAggregatedFrequencies(dataset);
        double[] res = new double[frequencies.length];
        for (int i = 0; i < frequencies.length; ++i) {
            Optional<Map.Entry> max = frequencies[i].entrySet().stream().min(Comparator.comparingInt(Map.Entry::getValue));
            if (!max.isPresent()) continue;
            res[i] = (Double)max.get().getKey();
        }
        return res;
    }

    private Map<Double, Integer>[] getAggregatedFrequencies(Dataset<EmptyContext, ImputerPartitionData> dataset) {
        return (Map[])dataset.compute(ImputerPartitionData::valuesByFrequency, (a, b) -> {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            assert (((Map[])a).length == ((Map[])b).length);
            for (int i = 0; i < ((Map[])a).length; ++i) {
                int finalI = i;
                a[i].forEach((k, v) -> b[finalI].merge(k, v, (f1, f2) -> f1 + f2));
            }
            return b;
        });
    }

    private double[] calculateImputingValuesByCounts(Dataset<EmptyContext, ImputerPartitionData> dataset) {
        int[] counts = (int[])dataset.compute(ImputerPartitionData::counts, (a, b) -> {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            assert (((int[])a).length == ((int[])b).length);
            for (int i = 0; i < ((int[])a).length; ++i) {
                int n = i;
                a[n] = a[n] + b[i];
            }
            return a;
        });
        double[] res = new double[counts.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = counts[i];
        }
        return res;
    }

    private double[] calculateImputingValuesByMinValues(Dataset<EmptyContext, ImputerPartitionData> dataset) {
        return (double[])dataset.compute(ImputerPartitionData::mins, (a, b) -> {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            assert (((double[])a).length == ((double[])b).length);
            for (int i = 0; i < ((double[])a).length; ++i) {
                a[i] = Math.min(a[i], b[i]);
            }
            return a;
        });
    }

    private double[] calculateImputingValuesByMaxValues(Dataset<EmptyContext, ImputerPartitionData> dataset) {
        return (double[])dataset.compute(ImputerPartitionData::maxs, (a, b) -> {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            assert (((double[])a).length == ((double[])b).length);
            for (int i = 0; i < ((double[])a).length; ++i) {
                a[i] = Math.max(a[i], b[i]);
            }
            return a;
        });
    }

    private double[] calculateImputingValuesBySumsAndCounts(Dataset<EmptyContext, ImputerPartitionData> dataset) {
        double[] sums = (double[])dataset.compute(ImputerPartitionData::sums, (a, b) -> {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            assert (((double[])a).length == ((double[])b).length);
            for (int i = 0; i < ((double[])a).length; ++i) {
                int n = i;
                a[n] = a[n] + b[i];
            }
            return a;
        });
        int[] counts = (int[])dataset.compute(ImputerPartitionData::counts, (a, b) -> {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            assert (((int[])a).length == ((int[])b).length);
            for (int i = 0; i < ((int[])a).length; ++i) {
                int n = i;
                a[n] = a[n] + b[i];
            }
            return a;
        });
        double[] means = new double[sums.length];
        for (int i = 0; i < means.length; ++i) {
            means[i] = sums[i] / (double)counts[i];
        }
        return means;
    }

    private Map<Double, Integer>[] updateFrequenciesByGivenRow(LabeledVector row, Map<Double, Integer>[] valuesByFreq) {
        int i;
        if (valuesByFreq == null) {
            valuesByFreq = new HashMap[row.size()];
            for (i = 0; i < valuesByFreq.length; ++i) {
                valuesByFreq[i] = new HashMap<Double, Integer>();
            }
        } else assert (valuesByFreq.length == row.size()) : "Base preprocessor must return exactly " + valuesByFreq.length + " features";
        for (i = 0; i < valuesByFreq.length; ++i) {
            double v = row.get(i);
            if (Double.valueOf(v).equals(Double.NaN)) continue;
            Map<Double, Integer> map = valuesByFreq[i];
            if (map.containsKey(v)) {
                map.put(v, map.get(v) + 1);
                continue;
            }
            map.put(v, 1);
        }
        return valuesByFreq;
    }

    private double[] updateTheSums(LabeledVector row, double[] sums) {
        if (sums == null) {
            sums = new double[row.size()];
        } else assert (sums.length == row.size()) : "Base preprocessor must return exactly " + sums.length + " features";
        for (int i = 0; i < sums.length; ++i) {
            if (Double.valueOf(row.get(i)).equals(Double.NaN)) continue;
            int n = i;
            sums[n] = sums[n] + row.get(i);
        }
        return sums;
    }

    private int[] updateTheCounts(LabeledVector row, int[] counts) {
        if (counts == null) {
            counts = new int[row.size()];
        } else assert (counts.length == row.size()) : "Base preprocessor must return exactly " + counts.length + " features";
        for (int i = 0; i < counts.length; ++i) {
            if (Double.valueOf(row.get(i)).equals(Double.NaN)) continue;
            int n = i;
            counts[n] = counts[n] + 1;
        }
        return counts;
    }

    private double[] updateTheMins(LabeledVector row, double[] mins) {
        int i;
        if (mins == null) {
            mins = new double[row.size()];
            for (i = 0; i < mins.length; ++i) {
                mins[i] = Double.POSITIVE_INFINITY;
            }
        } else assert (mins.length == row.size()) : "Base preprocessor must return exactly " + mins.length + " features";
        for (i = 0; i < mins.length; ++i) {
            if (Double.valueOf(row.get(i)).equals(Double.NaN)) continue;
            mins[i] = Math.min(mins[i], row.get(i));
        }
        return mins;
    }

    private double[] updateTheMaxs(LabeledVector row, double[] maxs) {
        int i;
        if (maxs == null) {
            maxs = new double[row.size()];
            for (i = 0; i < maxs.length; ++i) {
                maxs[i] = Double.NEGATIVE_INFINITY;
            }
        } else assert (maxs.length == row.size()) : "Base preprocessor must return exactly " + maxs.length + " features";
        for (i = 0; i < maxs.length; ++i) {
            if (Double.valueOf(row.get(i)).equals(Double.NaN)) continue;
            maxs[i] = Math.max(maxs[i], row.get(i));
        }
        return maxs;
    }

    public ImputerTrainer<K, V> withImputingStrategy(ImputingStrategy imputingStgy) {
        this.imputingStgy = imputingStgy;
        return this;
    }
}

