/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.inference.reader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.ignite.ml.inference.reader.ModelReader;
import org.apache.ignite.ml.inference.util.DirectorySerializer;

public class FileSystemModelReader
implements ModelReader {
    private static final long serialVersionUID = 7370932792669930039L;
    private final String path;

    public FileSystemModelReader(String path) {
        this.path = path;
    }

    @Override
    public byte[] read() {
        try {
            File file = Paths.get(this.path, new String[0]).toFile();
            if (!file.exists()) {
                throw new IllegalArgumentException("File or directory does not exist [path=" + this.path + "]");
            }
            if (file.isDirectory()) {
                return DirectorySerializer.serialize(Paths.get(this.path, new String[0]));
            }
            return Files.readAllBytes(Paths.get(this.path, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

