/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.source.flink;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.events.CacheEvent;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.source.flink.TaskRemoteFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgniteSource
extends RichParallelSourceFunction<CacheEvent> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(IgniteSource.class);
    private static final int DFLT_EVT_BATCH_SIZE = 1;
    private static final int DFLT_EVT_BUFFER_TIMEOUT = 10;
    private BlockingQueue<CacheEvent> evtBuf = new LinkedBlockingQueue<CacheEvent>();
    private UUID rmtLsnrId;
    private volatile boolean isRunning;
    private int evtBatchSize = 1;
    private int evtBufTimeout = 10;
    private final TaskLocalListener locLsnr = new TaskLocalListener();
    @IgniteInstanceResource
    private transient Ignite ignite;
    private final String cacheName;

    public void setIgnite(Ignite ignite) {
        this.ignite = ignite;
    }

    public void setEvtBatchSize(int evtBatchSize) {
        this.evtBatchSize = evtBatchSize;
    }

    public void setEvtBufTimeout(int evtBufTimeout) {
        this.evtBufTimeout = evtBufTimeout;
    }

    TaskLocalListener getLocLsnr() {
        return this.locLsnr;
    }

    public IgniteSource(String cacheName) {
        this.cacheName = cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(IgnitePredicate<CacheEvent> filter, int ... cacheEvts) {
        A.notNull((Object)this.cacheName, (String)"Cache name");
        TaskRemoteFilter rmtLsnr = new TaskRemoteFilter(this.cacheName, filter);
        try {
            IgniteSource igniteSource = this;
            synchronized (igniteSource) {
                if (this.isRunning) {
                    return;
                }
                this.isRunning = true;
                this.rmtLsnrId = this.ignite.events(this.ignite.cluster().forCacheNodes(this.cacheName)).remoteListen((IgniteBiPredicate)this.locLsnr, (IgnitePredicate)rmtLsnr, cacheEvts);
            }
        }
        catch (IgniteException e) {
            log.error("Failed to register event listener!", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(SourceFunction.SourceContext<CacheEvent> ctx) {
        ArrayList<CacheEvent> evts = new ArrayList<CacheEvent>(this.evtBatchSize);
        try {
            while (this.isRunning) {
                CacheEvent firstEvt = this.evtBuf.poll(1L, TimeUnit.SECONDS);
                if (firstEvt != null) {
                    evts.add(firstEvt);
                }
                if (this.evtBuf.drainTo(evts, this.evtBatchSize) <= 0) continue;
                Object object = ctx.getCheckpointLock();
                synchronized (object) {
                    for (CacheEvent evt : evts) {
                        ctx.collect((Object)evt);
                    }
                    evts.clear();
                }
            }
            return;
        }
        catch (Exception e) {
            if (X.hasCause((Throwable)e, (Class[])new Class[]{InterruptedException.class})) {
                return;
            }
            log.error("Error while processing cache event of " + this.cacheName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        IgniteSource igniteSource = this;
        synchronized (igniteSource) {
            if (!this.isRunning) {
                return;
            }
            this.isRunning = false;
            if (this.rmtLsnrId != null && this.ignite != null) {
                this.ignite.events(this.ignite.cluster().forCacheNodes(this.cacheName)).stopRemoteListen(this.rmtLsnrId);
                this.rmtLsnrId = null;
            }
        }
    }

    private class TaskLocalListener
    implements IgniteBiPredicate<UUID, CacheEvent> {
        private TaskLocalListener() {
        }

        public boolean apply(UUID id, CacheEvent evt) {
            try {
                if (!IgniteSource.this.evtBuf.offer(evt, IgniteSource.this.evtBufTimeout, TimeUnit.MILLISECONDS)) {
                    log.error("Failed to buffer event {}", (Object)evt.name());
                }
            }
            catch (InterruptedException ignored) {
                log.error("Failed to buffer event using local task listener {}", (Object)evt.name());
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }
}

