/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.ModelCategory;
import hex.genmodel.FolderMojoReaderBackend;
import hex.genmodel.GenModel;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.ZipfileMojoReaderBackend;
import hex.genmodel.attributes.ModelAttributes;
import hex.genmodel.descriptor.ModelDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class MojoModel
extends GenModel {
    public String _h2oVersion;
    public ModelCategory _category;
    public String _uuid;
    public boolean _supervised;
    public int _nfeatures;
    public int _nclasses;
    public boolean _balanceClasses;
    public double _defaultThreshold;
    public double[] _priorClassDistrib;
    public double[] _modelClassDistrib;
    public double _mojo_version;
    public ModelDescriptor _modelDescriptor = null;
    public ModelAttributes _modelAttributes = null;

    public static MojoModel load(String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            throw new FileNotFoundException("File " + file + " cannot be found.");
        }
        MojoReaderBackend cr = f.isDirectory() ? new FolderMojoReaderBackend(file) : new ZipfileMojoReaderBackend(file);
        return ModelMojoReader.readFrom(cr);
    }

    public static MojoModel load(MojoReaderBackend mojoReader) throws IOException {
        return ModelMojoReader.readFrom(mojoReader);
    }

    @Override
    public boolean isSupervised() {
        return this._supervised;
    }

    @Override
    public int nfeatures() {
        return this._nfeatures;
    }

    @Override
    public int nclasses() {
        return this._nclasses;
    }

    @Override
    public ModelCategory getModelCategory() {
        return this._category;
    }

    @Override
    public String getUUID() {
        return this._uuid;
    }

    protected MojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }
}

