/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.generators;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.UpstreamTransformerBuilder;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.structures.DatasetRow;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.util.generators.DatasetBuilderAdapter;
import org.apache.ignite.ml.util.generators.primitives.scalar.RandomProducer;

public interface DataStreamGenerator {
    public static final int FILL_CACHE_BATCH_SIZE = 1000;

    public Stream<LabeledVector<Double>> labeled();

    default public Stream<Vector> unlabeled() {
        return this.labeled().map(DatasetRow::features);
    }

    default public Stream<LabeledVector<Double>> labeled(IgniteFunction<Vector, Double> classifier) {
        return this.labeled().map(DatasetRow::features).map(v -> new LabeledVector((Vector)v, classifier.apply((Vector)v)));
    }

    default public DataStreamGenerator mapVectors(final IgniteFunction<Vector, Vector> f) {
        return new DataStreamGenerator(){

            @Override
            public Stream<LabeledVector<Double>> labeled() {
                return DataStreamGenerator.this.labeled().map(v -> new LabeledVector((Vector)f.apply(v.features()), v.label()));
            }
        };
    }

    default public DataStreamGenerator blur(RandomProducer rnd) {
        return this.mapVectors(rnd::noizify);
    }

    default public Map<Vector, Double> asMap(int datasetSize) {
        return this.labeled().limit(datasetSize).collect(Collectors.toMap(DatasetRow::features, LabeledVector::label));
    }

    default public DatasetBuilder<Vector, Double> asDatasetBuilder(int datasetSize, int partitions) {
        return new DatasetBuilderAdapter(this, datasetSize, partitions);
    }

    default public DatasetBuilder<Vector, Double> asDatasetBuilder(int datasetSize, IgniteBiPredicate<Vector, Double> filter, int partitions) {
        return new DatasetBuilderAdapter(this, datasetSize, filter, partitions);
    }

    default public DatasetBuilder<Vector, Double> asDatasetBuilder(int datasetSize, IgniteBiPredicate<Vector, Double> filter, int partitions, UpstreamTransformerBuilder upstreamTransformerBuilder) {
        return new DatasetBuilderAdapter(this, datasetSize, filter, partitions, upstreamTransformerBuilder);
    }

    default public <K> void fillCacheWithCustomKey(int datasetSize, IgniteCache<K, LabeledVector<Double>> cache, Function<LabeledVector<Double>, K> keyMapper) {
        HashMap batch = new HashMap();
        this.labeled().limit(datasetSize).forEach(vec -> {
            batch.put(keyMapper.apply((LabeledVector<Double>)vec), vec);
            if (batch.size() == 1000) {
                cache.putAll(batch);
                batch.clear();
            }
        });
        if (!batch.isEmpty()) {
            cache.putAll(batch);
        }
    }

    default public void fillCacheWithVecHashAsKey(int datasetSize, IgniteCache<Integer, LabeledVector<Double>> cache) {
        this.fillCacheWithCustomKey(datasetSize, cache, LabeledVector::hashCode);
    }

    default public void fillCacheWithVecUUIDAsKey(int datasetSize, IgniteCache<UUID, LabeledVector<Double>> cache) {
        this.fillCacheWithCustomKey(datasetSize, cache, v -> UUID.randomUUID());
    }
}

