/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.randomforest.data;

import java.io.Serializable;
import java.util.List;
import org.apache.ignite.ml.tree.randomforest.data.TreeNode;

public class NodeSplit
implements Serializable {
    private static final long serialVersionUID = 1331311529596106124L;
    private final int featureId;
    private final double val;
    private final double impurity;

    public NodeSplit(int featureId, double val, double impurity) {
        this.featureId = featureId;
        this.val = val;
        this.impurity = impurity;
    }

    public List<TreeNode> split(TreeNode node) {
        List<TreeNode> children = node.toConditional(this.featureId, this.val);
        node.setImpurity(this.impurity);
        return children;
    }

    public void createLeaf(TreeNode node) {
        node.setImpurity(this.impurity);
        node.toLeaf(0.0);
    }

    public double getImpurity() {
        return this.impurity;
    }

    public double getVal() {
        return this.val;
    }
}

