/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.structures.partition;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.structures.LabeledVectorSet;

public class LabeledDatasetPartitionDataBuilderOnHeap<K, V, C extends Serializable>
implements PartitionDataBuilder<K, V, C, LabeledVectorSet<LabeledVector>> {
    private static final long serialVersionUID = -7820760153954269227L;
    private final Preprocessor<K, V> preprocessor;

    public LabeledDatasetPartitionDataBuilderOnHeap(Preprocessor<K, V> preprocessor) {
        this.preprocessor = preprocessor;
    }

    @Override
    public LabeledVectorSet<LabeledVector> build(LearningEnvironment env, Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        int xCols = -1;
        double[][] x = null;
        double[] y = new double[Math.toIntExact(upstreamDataSize)];
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            LabeledVector labeledVector = (LabeledVector)this.preprocessor.apply(entry.getKey(), entry.getValue());
            Object row = labeledVector.features();
            if (xCols < 0) {
                xCols = row.size();
                x = new double[Math.toIntExact(upstreamDataSize)][xCols];
            } else assert (row.size() == xCols) : "X extractor must return exactly " + xCols + " columns";
            x[ptr] = row.asArray();
            y[ptr] = (Double)labeledVector.label();
            ++ptr;
        }
        return new LabeledVectorSet<LabeledVector>(x, y);
    }
}

