/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.knn.ann;

import org.apache.ignite.ml.knn.ann.ANNClassificationTrainer;
import org.apache.ignite.ml.knn.ann.KNNModelFormat;
import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.structures.LabeledVectorSet;

public class ANNModelFormat
extends KNNModelFormat {
    private final ANNClassificationTrainer.CentroidStat candidatesStat;
    private LabeledVectorSet<LabeledVector> candidates;

    public ANNModelFormat(int k, DistanceMeasure measure, boolean weighted, LabeledVectorSet<LabeledVector> candidates, ANNClassificationTrainer.CentroidStat candidatesStat) {
        this.k = k;
        this.distanceMeasure = measure;
        this.weighted = weighted;
        this.candidates = candidates;
        this.candidatesStat = candidatesStat;
    }

    public LabeledVectorSet<LabeledVector> getCandidates() {
        return this.candidates;
    }

    @Override
    public int hashCode() {
        int res = 1;
        res = res * 37 + this.k;
        res = res * 37 + this.distanceMeasure.hashCode();
        res = res * 37 + Boolean.hashCode(this.weighted);
        res = res * 37 + this.candidates.hashCode();
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ANNModelFormat that = (ANNModelFormat)obj;
        return this.k == that.k && this.distanceMeasure.equals(that.distanceMeasure) && this.weighted == that.weighted && this.candidates.equals(that.candidates);
    }
}

