/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.internal.BaseComputeService;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.googlecloud.internal.ListPages;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.features.FirewallApi;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;

public final class GoogleComputeEngineService
extends BaseComputeService {
    private final Function<Set<? extends NodeMetadata>, Set<String>> findOrphanedGroups;
    private final GroupNamingConvention.Factory namingConvention;
    private final GoogleComputeEngineApi api;
    private final Predicate<AtomicReference<Operation>> operationDone;

    @Inject
    GoogleComputeEngineService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwareProfiles, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy resumeNodeStrategy, SuspendNodeStrategy suspendNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, @Named(value="DEFAULT") Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, InitAdminAccess initAdminAccess, RunScriptOnNode.Factory runScriptOnNodeFactory, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, Optional<ImageExtension> imageExtension, Optional<SecurityGroupExtension> securityGroupExtension, Function<Set<? extends NodeMetadata>, Set<String>> findOrphanedGroups, GroupNamingConvention.Factory namingConvention, GoogleComputeEngineApi api, Predicate<AtomicReference<Operation>> operationDone) {
        super(context, credentialStore, images, hardwareProfiles, locations, listNodesStrategy, getImageStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, resumeNodeStrategy, suspendNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, initScriptRunnerFactory, initAdminAccess, runScriptOnNodeFactory, persistNodeCredentials, timeouts, userExecutor, imageExtension, securityGroupExtension);
        this.findOrphanedGroups = findOrphanedGroups;
        this.namingConvention = namingConvention;
        this.api = api;
        this.operationDone = operationDone;
    }

    public void destroyNode(String id) {
        NodeMetadata node = this.getNodeMetadata(id);
        super.destroyNode(id);
        this.cleanUpIncidentalResourcesOfDeadNodes((Set<? extends NodeMetadata>)ImmutableSet.of((Object)node));
    }

    public Set<? extends NodeMetadata> destroyNodesMatching(Predicate<NodeMetadata> filter) {
        HashSet nodes = Sets.newHashSet((Iterable)Iterables.filter((Iterable)this.listNodesDetailsMatching(NodePredicates.all()), filter));
        super.destroyNodesMatching(filter);
        this.cleanUpIncidentalResourcesOfDeadNodes(nodes);
        return nodes;
    }

    protected synchronized void cleanUpIncidentalResourcesOfDeadNodes(Set<? extends NodeMetadata> deadNodes) {
        Set orphanedGroups = (Set)this.findOrphanedGroups.apply(deadNodes);
        for (String orphanedGroup : orphanedGroups) {
            this.cleanUpNetworksAndFirewallsForGroup(orphanedGroup);
        }
    }

    private void cleanUpNetworksAndFirewallsForGroup(String groupName) {
        String resourceName = this.namingConvention.create().sharedNameForGroup(groupName);
        Network network = this.api.networks().get(resourceName);
        FirewallApi firewallApi = this.api.firewalls();
        if (network != null) {
            for (Firewall firewall : ListPages.concat(firewallApi.list())) {
                if (firewall == null || firewall.network() == null || !firewall.network().equals(network.selfLink())) continue;
                AtomicReference operation = Atomics.newReference((Object)firewallApi.delete(firewall.name()));
                this.operationDone.apply((Object)operation);
                if (((Operation)operation.get()).httpErrorStatusCode() == null) continue;
                this.logger.warn("delete orphaned firewall %s failed. Http Error Code: %d HttpError: %s", new Object[]{((Operation)operation.get()).targetId(), ((Operation)operation.get()).httpErrorStatusCode(), ((Operation)operation.get()).httpErrorMessage()});
            }
            AtomicReference operation = Atomics.newReference((Object)this.api.networks().delete(resourceName));
            this.operationDone.apply((Object)operation);
            if (((Operation)operation.get()).httpErrorStatusCode() != null) {
                this.logger.warn("delete orphaned network failed. Http Error Code: " + ((Operation)operation.get()).httpErrorStatusCode() + " HttpError: " + ((Operation)operation.get()).httpErrorMessage(), new Object[0]);
            }
        }
    }

    public GoogleComputeEngineTemplateOptions templateOptions() {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.templateOptions()));
    }
}

