/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.sys.SystemViewH2Adapter;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;

public class SqlSystemIndex
extends BaseIndex {
    private static final int DISTRIBUTED_MUL = 100;

    SqlSystemIndex(SystemViewH2Adapter tbl, Column ... col) {
        IndexColumn[] idxCols = col != null && col.length > 0 ? IndexColumn.wrap((Column[])col) : new IndexColumn[]{};
        this.initBaseIndex((Table)tbl, 0, null, idxCols, IndexType.createNonUnique((boolean)false));
    }

    public void close(Session ses) {
    }

    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"system view is read-only");
    }

    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"system view is read-only");
    }

    public Cursor find(Session ses, SearchRow first, SearchRow last) {
        assert (this.table instanceof SystemViewH2Adapter);
        Iterator<Row> rows = ((SystemViewH2Adapter)this.table).getRows(ses, first, last);
        return new GridH2Cursor(rows);
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColsSet) {
        long rowCnt = this.getRowCountApproximation();
        double baseCost = this.getCostRangeIndex(masks, rowCnt, filters, filter, sortOrder, false, allColsSet);
        if (((SystemViewH2Adapter)this.table).view.isDistributed()) {
            baseCost *= 100.0;
        }
        return baseCost;
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"system view cannot be truncated");
    }

    public void remove(Session ses) {
        throw DbException.getUnsupportedException((String)"system view cannot be removed");
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"system view cannot be renamed");
    }

    public boolean needRebuild() {
        return false;
    }

    public String getCreateSQL() {
        return null;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session ses, boolean first) {
        throw DbException.getUnsupportedException((String)"system views cannot be used to get first or last value");
    }

    public long getRowCount(Session ses) {
        return this.table.getRowCount(ses);
    }

    public long getRowCountApproximation() {
        return this.table.getRowCountApproximation();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }
}

