/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.CommandProcessor;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.QueryDescriptor;
import org.apache.ignite.internal.processors.query.h2.QueryParameters;
import org.apache.ignite.internal.processors.query.h2.QueryParserCacheEntry;
import org.apache.ignite.internal.processors.query.h2.QueryParserResult;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultCommand;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultDml;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultSelect;
import org.apache.ignite.internal.processors.query.h2.dml.DmlAstUtils;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContextRegistry;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlInsert;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuerySplitter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.sql.SqlParseException;
import org.apache.ignite.internal.sql.SqlParser;
import org.apache.ignite.internal.sql.SqlStrictParseException;
import org.apache.ignite.internal.sql.command.SqlAlterTableCommand;
import org.apache.ignite.internal.sql.command.SqlAlterUserCommand;
import org.apache.ignite.internal.sql.command.SqlBeginTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlBulkLoadCommand;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCommitTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlCreateIndexCommand;
import org.apache.ignite.internal.sql.command.SqlCreateUserCommand;
import org.apache.ignite.internal.sql.command.SqlDropIndexCommand;
import org.apache.ignite.internal.sql.command.SqlDropUserCommand;
import org.apache.ignite.internal.sql.command.SqlKillQueryCommand;
import org.apache.ignite.internal.sql.command.SqlRollbackTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlSetStreamingCommand;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.command.Prepared;
import org.jetbrains.annotations.Nullable;

public class QueryParser {
    private static final int CACHE_SIZE = 1024;
    private static final Pattern INTERNAL_CMD_RE = Pattern.compile("^(create|drop)\\s+index|^alter\\s+table|^copy|^set|^begin|^commit|^rollback|^(create|alter|drop)\\s+user|^kill\\s+query|show|help|grant|revoke", 2);
    private final IgniteH2Indexing idx;
    private final ConnectionManager connMgr;
    private final IgniteLogger log;
    private volatile GridBoundedConcurrentLinkedHashMap<QueryDescriptor, QueryParserCacheEntry> cache = new GridBoundedConcurrentLinkedHashMap(1024);

    public QueryParser(IgniteH2Indexing idx, ConnectionManager connMgr) {
        this.idx = idx;
        this.connMgr = connMgr;
        this.log = idx.kernalContext().log(QueryParser.class);
    }

    public QueryParserResult parse(String schemaName, SqlFieldsQuery qry, boolean remainingAllowed) {
        QueryParserResult res = this.parse0(schemaName, qry, remainingAllowed);
        QueryParser.checkQueryType(qry, res.isSelect());
        return res;
    }

    public QueryParameters queryParameters(SqlFieldsQuery qry) {
        NestedTxMode nestedTxMode = NestedTxMode.DEFAULT;
        boolean autoCommit = true;
        List batchedArgs = null;
        if (qry instanceof SqlFieldsQueryEx) {
            SqlFieldsQueryEx qry0 = (SqlFieldsQueryEx)qry;
            if (qry0.getNestedTxMode() != null) {
                nestedTxMode = qry0.getNestedTxMode();
            }
            autoCommit = qry0.isAutoCommit();
            batchedArgs = qry0.batchedArguments();
        }
        int timeout = qry.getTimeout() >= 0 ? qry.getTimeout() : (int)this.idx.kernalContext().config().getDefaultQueryTimeout();
        return new QueryParameters(qry.getArgs(), qry.getPartitions(), timeout, qry.isLazy(), qry.getPageSize(), null, nestedTxMode, autoCommit, batchedArgs, qry.getUpdateBatchSize());
    }

    private QueryParserResult parse0(String schemaName, SqlFieldsQuery qry, boolean remainingAllowed) {
        QueryDescriptor qryDesc = QueryParser.queryDescriptor(schemaName, qry);
        QueryParserCacheEntry cached = (QueryParserCacheEntry)this.cache.get((Object)qryDesc);
        if (cached != null) {
            return new QueryParserResult(qryDesc, this.queryParameters(qry), null, cached.parametersMeta(), cached.select(), cached.dml(), cached.command());
        }
        QueryParserResult parseRes = this.parseNative(schemaName, qry, remainingAllowed);
        if (parseRes == null) {
            parseRes = this.parseH2(schemaName, qry, qryDesc.batched(), remainingAllowed);
        }
        if (parseRes.remainingQuery() == null) {
            cached = new QueryParserCacheEntry(parseRes.parametersMeta(), parseRes.select(), parseRes.dml(), parseRes.command());
            this.cache.put((Object)qryDesc, (Object)cached);
        }
        return parseRes;
    }

    @Nullable
    private QueryParserResult parseNative(String schemaName, SqlFieldsQuery qry, boolean remainingAllowed) {
        String sql = qry.getSql();
        if (!INTERNAL_CMD_RE.matcher(sql.trim()).find()) {
            return null;
        }
        try {
            SqlParser parser = new SqlParser(schemaName, sql);
            SqlCommand nativeCmd = parser.nextCommand();
            assert (nativeCmd != null) : "Empty query. Parser met end of data";
            if (!(nativeCmd instanceof SqlCreateIndexCommand || nativeCmd instanceof SqlDropIndexCommand || nativeCmd instanceof SqlBeginTransactionCommand || nativeCmd instanceof SqlCommitTransactionCommand || nativeCmd instanceof SqlRollbackTransactionCommand || nativeCmd instanceof SqlBulkLoadCommand || nativeCmd instanceof SqlAlterTableCommand || nativeCmd instanceof SqlSetStreamingCommand || nativeCmd instanceof SqlCreateUserCommand || nativeCmd instanceof SqlAlterUserCommand || nativeCmd instanceof SqlDropUserCommand || nativeCmd instanceof SqlKillQueryCommand)) {
                return null;
            }
            SqlFieldsQuery newQry = QueryParser.cloneFieldsQuery(qry).setSql(parser.lastCommandSql());
            QueryDescriptor newPlanKey = QueryParser.queryDescriptor(schemaName, newQry);
            SqlFieldsQuery remainingQry = null;
            if (!F.isEmpty((String)parser.remainingSql())) {
                QueryParser.checkRemainingAllowed(remainingAllowed);
                remainingQry = QueryParser.cloneFieldsQuery(qry).setSql(parser.remainingSql()).setArgs(qry.getArgs());
            }
            QueryParserResultCommand cmd = new QueryParserResultCommand(nativeCmd, null, false);
            return new QueryParserResult(newPlanKey, this.queryParameters(newQry), remainingQry, Collections.emptyList(), null, null, cmd);
        }
        catch (SqlStrictParseException e) {
            throw new IgniteSQLException(e.getMessage(), e.errorCode(), (Throwable)e);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to parse SQL with native parser [qry=" + sql + ", err=" + e + ']');
            }
            if (!IgniteSystemProperties.getBoolean((String)"IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK")) {
                return null;
            }
            int code = 1001;
            if (e instanceof SqlParseException) {
                code = ((SqlParseException)e).code();
            }
            throw new IgniteSQLException("Failed to parse DDL statement: " + sql + ": " + e.getMessage(), code, (Throwable)e);
        }
    }

    private QueryParserResult parseH2(String schemaName, SqlFieldsQuery qry, boolean batched, boolean remainingAllowed) {
        Connection c = this.connMgr.connectionForThread().connection(schemaName);
        boolean enforceJoinOrderOnParsing = !qry.isLocal() || qry.isEnforceJoinOrder();
        H2Utils.setupConnection(c, false, enforceJoinOrderOnParsing);
        QueryContext qctx = new QueryContext(0, this.idx.backupFilter(null, null), null, null, null, qry.isLocal());
        QueryContextRegistry qryCtxRegistry = this.idx.queryContextRegistry();
        qryCtxRegistry.setThreadLocal(qctx);
        PreparedStatement stmt = null;
        try {
            GridCacheContext cctx;
            List<JdbcParameterMeta> paramsMeta;
            stmt = this.connMgr.prepareStatementNoCache(c, qry.getSql());
            if (qry.isLocal() && GridSqlQueryParser.checkMultipleStatements(stmt)) {
                throw new IgniteSQLException("Multiple statements queries are not supported for local queries.", 1002);
            }
            GridSqlQueryParser.PreparedWithRemaining prep = GridSqlQueryParser.preparedWithRemaining(stmt);
            Prepared prepared = prep.prepared();
            if (GridSqlQueryParser.isExplainUpdate(prepared)) {
                throw new IgniteSQLException("Explains of update queries are not supported.", 1002);
            }
            SqlFieldsQuery remainingQry = null;
            if (!F.isEmpty((String)prep.remainingSql())) {
                QueryParser.checkRemainingAllowed(remainingAllowed);
                remainingQry = QueryParser.cloneFieldsQuery(qry).setSql(prep.remainingSql());
            }
            SqlFieldsQuery newQry = QueryParser.cloneFieldsQuery(qry).setSql(prepared.getSQL());
            int paramsCnt = prepared.getParameters().size();
            Object[] argsOrig = qry.getArgs();
            Object[] args = null;
            Object[] remainingArgs = null;
            if (!batched && paramsCnt > 0) {
                if (argsOrig == null || argsOrig.length < paramsCnt) {
                    args = argsOrig;
                } else {
                    args = Arrays.copyOfRange(argsOrig, 0, paramsCnt);
                    if (paramsCnt != argsOrig.length) {
                        remainingArgs = Arrays.copyOfRange(argsOrig, paramsCnt, argsOrig.length);
                    }
                }
            } else {
                remainingArgs = argsOrig;
            }
            newQry.setArgs(args);
            QueryDescriptor newQryDesc = QueryParser.queryDescriptor(schemaName, newQry);
            if (remainingQry != null) {
                remainingQry.setArgs(remainingArgs);
            }
            try {
                paramsMeta = H2Utils.parametersMeta(stmt.getParameterMetaData());
                assert (prepared.getParameters().size() == paramsMeta.size());
            }
            catch (SQLException | IgniteCheckedException e) {
                throw new IgniteSQLException("Failed to get parameters metadata", 1, e);
            }
            if (CommandProcessor.isCommand(prepared)) {
                GridSqlStatement cmdH2 = new GridSqlQueryParser(false).parse(prepared);
                QueryParserResultCommand cmd2 = new QueryParserResultCommand(null, cmdH2, false);
                QueryParserResult queryParserResult = new QueryParserResult(newQryDesc, this.queryParameters(newQry), remainingQry, paramsMeta, null, null, cmd2);
                return queryParserResult;
            }
            if (CommandProcessor.isCommandNoOp(prepared)) {
                QueryParserResultCommand cmd = new QueryParserResultCommand(null, null, true);
                QueryParserResult cmd2 = new QueryParserResult(newQryDesc, this.queryParameters(newQry), remainingQry, paramsMeta, null, null, cmd);
                return cmd2;
            }
            if (GridSqlQueryParser.isDml(prepared)) {
                QueryParserResultDml dml = this.prepareDmlStatement(newQryDesc, prepared);
                QueryParserResult cmd2 = new QueryParserResult(newQryDesc, this.queryParameters(newQry), remainingQry, paramsMeta, null, dml, null);
                return cmd2;
            }
            if (!prepared.isQuery()) {
                throw new IgniteSQLException("Unsupported statement: " + newQry.getSql(), 1002);
            }
            GridSqlQueryParser parser = new GridSqlQueryParser(false);
            GridSqlQuery selectStmt = (GridSqlQuery)parser.parse(prepared);
            List<Integer> cacheIds = parser.cacheIds();
            Integer mvccCacheId = this.mvccCacheIdForSelect(parser.objectsMap());
            boolean loc = qry.isLocal();
            if (!loc && parser.isLocalQuery()) {
                loc = true;
            }
            boolean locSplit = false;
            if (loc && (cctx = parser.getFirstPartitionedCache()) != null && cctx.config().getQueryParallelism() > 1) {
                locSplit = true;
            }
            boolean splitNeeded = !loc || locSplit;
            String forUpdateQryOutTx = null;
            String forUpdateQryTx = null;
            GridCacheTwoStepQuery forUpdateTwoStepQry = null;
            boolean forUpdate = GridSqlQueryParser.isForUpdateQuery(prepared);
            if (forUpdate) {
                assert (selectStmt instanceof GridSqlSelect);
                if (cacheIds.size() != 1) {
                    throw new IgniteSQLException("SELECT FOR UPDATE is supported only for queries that involve single transactional cache.");
                }
                if (mvccCacheId == null) {
                    throw new IgniteSQLException("SELECT FOR UPDATE query requires transactional cache with MVCC enabled.", 1002);
                }
                GridSqlSelect selForUpdate = ((GridSqlSelect)selectStmt).copySelectForUpdate();
                selForUpdate.forUpdate(false);
                ((GridSqlSelect)selectStmt).forUpdate(false);
                forUpdateQryOutTx = selForUpdate.getSQL();
                GridSqlAlias keyCol = GridSqlQuerySplitter.keyColumn(selForUpdate);
                selForUpdate.addColumn(keyCol, true);
                forUpdateQryTx = selForUpdate.getSQL();
                if (splitNeeded) {
                    forUpdateTwoStepQry = GridSqlQuerySplitter.split(this.connMgr.connectionForThread().connection(newQry.getSchema()), selForUpdate, forUpdateQryTx, newQry.isCollocated(), newQry.isDistributedJoins(), newQry.isEnforceJoinOrder(), locSplit, this.idx, paramsCnt);
                }
            }
            GridCacheTwoStepQuery twoStepQry = null;
            if (splitNeeded) {
                twoStepQry = GridSqlQuerySplitter.split(this.connMgr.connectionForThread().connection(newQry.getSchema()), selectStmt, newQry.getSql(), newQry.isCollocated(), newQry.isDistributedJoins(), newQry.isEnforceJoinOrder(), locSplit, this.idx, paramsCnt);
            }
            List<GridQueryFieldMetadata> meta = H2Utils.meta(stmt.getMetaData());
            QueryParserResultSelect select = new QueryParserResultSelect(selectStmt, twoStepQry, forUpdateTwoStepQry, meta, cacheIds, mvccCacheId, forUpdateQryOutTx, forUpdateQryTx);
            QueryParserResult queryParserResult = new QueryParserResult(newQryDesc, this.queryParameters(newQry), remainingQry, paramsMeta, select, null, null);
            return queryParserResult;
        }
        catch (SQLException | IgniteCheckedException e) {
            throw new IgniteSQLException("Failed to parse query. " + e.getMessage(), 1001, e);
        }
        finally {
            qryCtxRegistry.clearThreadLocal();
            U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
        }
    }

    private static void checkRemainingAllowed(boolean allowed) {
        if (allowed) {
            return;
        }
        throw new IgniteSQLException("Multiple statements queries are not supported.", 1002);
    }

    private Integer mvccCacheIdForSelect(Map<Object, Object> objMap) {
        Boolean mvccEnabled = null;
        Integer mvccCacheId = null;
        GridCacheContextInfo cctx = null;
        for (Object o : objMap.values()) {
            boolean curMvccEnabled;
            GridSqlTable tbl;
            if (o instanceof GridSqlAlias) {
                o = GridSqlAlias.unwrap((GridSqlAst)o);
            }
            if (!(o instanceof GridSqlTable) || ((GridSqlTable)o).dataTable() == null || (tbl = (GridSqlTable)o).dataTable() == null) continue;
            GridCacheContextInfo curCctx = tbl.dataTable().cacheInfo();
            assert (curCctx != null);
            boolean bl = curMvccEnabled = curCctx.config().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT;
            if (mvccEnabled == null) {
                mvccEnabled = curMvccEnabled;
                if (mvccEnabled.booleanValue()) {
                    mvccCacheId = curCctx.cacheId();
                }
                cctx = curCctx;
                continue;
            }
            if (mvccEnabled == curMvccEnabled) continue;
            MvccUtils.throwAtomicityModesMismatchException((CacheConfiguration)cctx.config(), (CacheConfiguration)curCctx.config());
        }
        return mvccCacheId;
    }

    private QueryParserResultDml prepareDmlStatement(QueryDescriptor planKey, Prepared prepared) {
        UpdatePlan plan;
        if (F.eq((Object)QueryUtils.SCHEMA_SYS, (Object)planKey.schemaName())) {
            throw new IgniteSQLException("DML statements are not supported on " + planKey.schemaName() + " schema", 1002);
        }
        GridSqlQueryParser parser = new GridSqlQueryParser(false);
        GridSqlStatement stmt = parser.parse(prepared);
        List<GridH2Table> tbls = parser.tablesForDml();
        for (GridH2Table h2tbl : tbls) {
            H2Utils.checkAndStartNotStartedCache(this.idx.kernalContext(), h2tbl);
        }
        GridCacheContextInfo ctx = null;
        boolean mvccEnabled = false;
        for (GridH2Table h2tbl : tbls) {
            boolean curMvccEnabled;
            GridCacheContextInfo curCtx = h2tbl.cacheInfo();
            boolean bl = curMvccEnabled = curCtx.config().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT;
            if (ctx == null) {
                ctx = curCtx;
                mvccEnabled = curMvccEnabled;
                continue;
            }
            if (curMvccEnabled == mvccEnabled) continue;
            MvccUtils.throwAtomicityModesMismatchException((CacheConfiguration)ctx.config(), (CacheConfiguration)curCtx.config());
        }
        GridH2Table streamTbl = null;
        if (GridSqlQueryParser.isStreamableInsertStatement(prepared)) {
            GridSqlInsert insert = (GridSqlInsert)stmt;
            streamTbl = DmlAstUtils.gridTableForElement(insert.into()).dataTable();
        }
        try {
            plan = UpdatePlanBuilder.planForStatement(planKey, stmt, mvccEnabled, this.idx);
        }
        catch (Exception e) {
            if (e instanceof IgniteSQLException) {
                throw (IgniteSQLException)e;
            }
            throw new IgniteSQLException("Failed to prepare update plan.", (Throwable)e);
        }
        return new QueryParserResultDml(stmt, mvccEnabled, streamTbl, plan);
    }

    public void clearCache() {
        this.cache = new GridBoundedConcurrentLinkedHashMap(1024);
    }

    private static void checkQueryType(SqlFieldsQuery qry, boolean isQry) {
        Boolean qryFlag;
        Boolean bl = qryFlag = qry instanceof SqlFieldsQueryEx ? ((SqlFieldsQueryEx)qry).isQuery() : null;
        if (qryFlag != null && qryFlag != isQry) {
            throw new IgniteSQLException("Given statement type does not match that declared by JDBC driver", 3003);
        }
    }

    private static SqlFieldsQuery cloneFieldsQuery(SqlFieldsQuery oldQry) {
        return oldQry.copy().setLocal(oldQry.isLocal()).setPageSize(oldQry.getPageSize());
    }

    private static QueryDescriptor queryDescriptor(String schemaName, SqlFieldsQuery qry) {
        boolean skipReducerOnUpdate = false;
        boolean batched = false;
        if (qry instanceof SqlFieldsQueryEx) {
            SqlFieldsQueryEx qry0 = (SqlFieldsQueryEx)qry;
            skipReducerOnUpdate = !qry.isLocal() && qry0.isSkipReducerOnUpdate();
            batched = qry0.isBatched();
        }
        return new QueryDescriptor(schemaName, qry.getSql(), qry.isCollocated(), qry.isDistributedJoins(), qry.isEnforceJoinOrder(), qry.isLocal(), skipReducerOnUpdate, batched);
    }
}

