/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream.kafka.connect;

import java.util.Collection;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.Ignition;
import org.apache.ignite.stream.StreamSingleTupleExtractor;
import org.apache.ignite.stream.kafka.connect.IgniteSinkConnector;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgniteSinkTask
extends SinkTask {
    private static final Logger log = LoggerFactory.getLogger(IgniteSinkTask.class);
    private static volatile boolean stopped = true;
    private static String igniteConfigFile;
    private static String cacheName;
    private static StreamSingleTupleExtractor<SinkRecord, Object, Object> extractor;

    public String version() {
        return new IgniteSinkConnector().version();
    }

    public void start(Map<String, String> props) {
        String transformerCls;
        if (cacheName != null) {
            return;
        }
        cacheName = props.get("cacheName");
        igniteConfigFile = props.get("igniteCfg");
        if (props.containsKey("cacheAllowOverwrite")) {
            StreamerContext.getStreamer().allowOverwrite(Boolean.parseBoolean(props.get("cacheAllowOverwrite")));
        }
        if (props.containsKey("cachePerNodeDataSize")) {
            StreamerContext.getStreamer().perNodeBufferSize(Integer.parseInt(props.get("cachePerNodeDataSize")));
        }
        if (props.containsKey("cachePerNodeParOps")) {
            StreamerContext.getStreamer().perNodeParallelOperations(Integer.parseInt(props.get("cachePerNodeParOps")));
        }
        if (props.containsKey("singleTupleExtractorCls") && (transformerCls = props.get("singleTupleExtractorCls")) != null && !transformerCls.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(transformerCls);
                extractor = (StreamSingleTupleExtractor)clazz.newInstance();
            }
            catch (Exception e) {
                throw new ConnectException("Failed to instantiate the provided transformer!", (Throwable)e);
            }
        }
        stopped = false;
    }

    public void put(Collection<SinkRecord> records) {
        try {
            for (SinkRecord record : records) {
                if (extractor != null) {
                    Map.Entry entry = extractor.extract((Object)record);
                    StreamerContext.getStreamer().addData(entry.getKey(), entry.getValue());
                    continue;
                }
                if (record.key() != null) {
                    StreamerContext.getStreamer().addData(record.key(), record.value());
                    continue;
                }
                log.error("Failed to stream a record with null key!");
            }
        }
        catch (ConnectException e) {
            log.error("Failed adding record", (Throwable)e);
            throw new ConnectException((Throwable)e);
        }
    }

    public void flush(Map<TopicPartition, OffsetAndMetadata> offsets) {
        if (stopped) {
            return;
        }
        StreamerContext.getStreamer().flush();
    }

    public void stop() {
        if (stopped) {
            return;
        }
        stopped = true;
        StreamerContext.getIgnite().close();
    }

    protected static void setStopped(boolean stopped) {
        IgniteSinkTask.stopped = stopped;
        extractor = null;
    }

    static /* synthetic */ String access$000() {
        return igniteConfigFile;
    }

    static /* synthetic */ String access$100() {
        return cacheName;
    }

    public static class StreamerContext {
        private StreamerContext() {
        }

        public static Ignite getIgnite() {
            return Holder.IGNITE;
        }

        public static IgniteDataStreamer getStreamer() {
            return Holder.STREAMER;
        }

        private static class Holder {
            private static final Ignite IGNITE = Ignition.start((String)IgniteSinkTask.access$000());
            private static final IgniteDataStreamer STREAMER = IGNITE.dataStreamer(IgniteSinkTask.access$100());

            private Holder() {
            }
        }
    }
}

