/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.baseline;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.baseline.VisorBaselineAutoAdjustSettings;
import org.apache.ignite.internal.visor.baseline.VisorBaselineNode;

public class VisorBaselineTaskResult
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean active;
    private long topVer;
    private Map<String, VisorBaselineNode> baseline;
    private Map<String, VisorBaselineNode> servers;
    private VisorBaselineAutoAdjustSettings autoAdjustSettings;
    private long remainingTimeToBaselineAdjust = -1L;
    private boolean baselineAdjustInProgress = false;

    public VisorBaselineTaskResult() {
    }

    private static Map<String, VisorBaselineNode> toMap(Collection<? extends BaselineNode> nodes) {
        if (F.isEmpty(nodes)) {
            return null;
        }
        TreeMap<String, VisorBaselineNode> map = new TreeMap<String, VisorBaselineNode>();
        for (BaselineNode baselineNode : nodes) {
            VisorBaselineNode dto = new VisorBaselineNode(baselineNode);
            map.put(dto.getConsistentId(), dto);
        }
        return map;
    }

    public VisorBaselineTaskResult(boolean active, long topVer, Collection<? extends BaselineNode> baseline, Collection<? extends BaselineNode> servers, VisorBaselineAutoAdjustSettings autoAdjustSettings, long remainingTimeToBaselineAdjust, boolean baselineAdjustInProgress) {
        this.active = active;
        this.topVer = topVer;
        this.baseline = VisorBaselineTaskResult.toMap(baseline);
        this.servers = VisorBaselineTaskResult.toMap(servers);
        this.autoAdjustSettings = autoAdjustSettings;
        this.remainingTimeToBaselineAdjust = remainingTimeToBaselineAdjust;
        this.baselineAdjustInProgress = baselineAdjustInProgress;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getTopologyVersion() {
        return this.topVer;
    }

    public Map<String, VisorBaselineNode> getBaseline() {
        return this.baseline;
    }

    public Map<String, VisorBaselineNode> getServers() {
        return this.servers;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    public VisorBaselineAutoAdjustSettings getAutoAdjustSettings() {
        return this.autoAdjustSettings;
    }

    public long getRemainingTimeToBaselineAdjust() {
        return this.remainingTimeToBaselineAdjust;
    }

    public boolean isBaselineAdjustInProgress() {
        return this.baselineAdjustInProgress;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.active);
        out.writeLong(this.topVer);
        U.writeMap(out, this.baseline);
        U.writeMap(out, this.servers);
        out.writeObject(this.autoAdjustSettings);
        out.writeLong(this.remainingTimeToBaselineAdjust);
        out.writeBoolean(this.baselineAdjustInProgress);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.active = in.readBoolean();
        this.topVer = in.readLong();
        this.baseline = U.readTreeMap(in);
        this.servers = U.readTreeMap(in);
        if (protoVer > 1) {
            this.autoAdjustSettings = (VisorBaselineAutoAdjustSettings)in.readObject();
            this.remainingTimeToBaselineAdjust = in.readLong();
            this.baselineAdjustInProgress = in.readBoolean();
        }
    }

    public String toString() {
        return S.toString(VisorBaselineTaskResult.class, this);
    }
}

