/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;

public class SecurityUtils {
    private static final int DFLT_SERIALIZE_VERSION = SecurityUtils.isSecurityCompatibilityMode() ? 1 : 2;
    private static final ThreadLocal<Integer> SERIALIZE_VERSION = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return DFLT_SERIALIZE_VERSION;
        }
    };

    private SecurityUtils() {
    }

    public static boolean isSecurityCompatibilityMode() {
        return IgniteSystemProperties.getBoolean("IGNITE_SECURITY_COMPATIBILITY_MODE", false);
    }

    public static void serializeVersion(int ver) {
        SERIALIZE_VERSION.set(ver);
    }

    public static int serializeVersion() {
        return SERIALIZE_VERSION.get();
    }

    public static void restoreDefaultSerializeVersion() {
        SecurityUtils.serializeVersion(DFLT_SERIALIZE_VERSION);
    }

    public static Map<String, Collection<SecurityPermission>> compatibleServicePermissions() {
        HashMap<String, Collection<SecurityPermission>> srvcPerms = new HashMap<String, Collection<SecurityPermission>>();
        srvcPerms.put("*", Arrays.asList(SecurityPermission.SERVICE_CANCEL, SecurityPermission.SERVICE_DEPLOY, SecurityPermission.SERVICE_INVOKE));
        return srvcPerms;
    }

    public static SecurityContext nodeSecurityContext(Marshaller marsh, ClassLoader ldr, ClusterNode node) {
        byte[] subjBytes = (byte[])node.attribute("org.apache.ignite.security.subject.v2");
        if (subjBytes == null) {
            throw new SecurityException("Security context isn't certain.");
        }
        try {
            return (SecurityContext)U.unmarshal(marsh, subjBytes, ldr);
        }
        catch (IgniteCheckedException e) {
            throw new SecurityException("Failed to get security context.", e);
        }
    }
}

