/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUtils;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResultMarshaler;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcQueryExecuteResult
extends JdbcResult {
    private long cursorId;
    private List<List<Object>> items;
    private boolean last;
    private boolean isQuery;
    private long updateCnt;
    private PartitionResult partRes;

    JdbcQueryExecuteResult() {
        super((byte)2);
    }

    JdbcQueryExecuteResult(long cursorId, List<List<Object>> items, boolean last, PartitionResult partRes) {
        super((byte)2);
        this.cursorId = cursorId;
        this.items = items;
        this.last = last;
        this.isQuery = true;
        this.partRes = partRes;
    }

    public JdbcQueryExecuteResult(long cursorId, long updateCnt, PartitionResult partRes) {
        super((byte)2);
        this.cursorId = cursorId;
        this.last = true;
        this.isQuery = false;
        this.updateCnt = updateCnt;
        this.partRes = partRes;
    }

    public long cursorId() {
        return this.cursorId;
    }

    public List<List<Object>> items() {
        return this.items;
    }

    public boolean last() {
        return this.last;
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public long updateCount() {
        return this.updateCnt;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        writer.writeLong(this.cursorId);
        writer.writeBoolean(this.isQuery);
        if (this.isQuery) {
            assert (this.items != null);
            writer.writeBoolean(this.last);
            JdbcUtils.writeItems(writer, this.items);
        } else {
            writer.writeLong(this.updateCnt);
        }
        writer.writeBoolean(this.partRes != null);
        if (this.partRes != null) {
            PartitionResultMarshaler.marshal(writer, this.partRes);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        this.cursorId = reader.readLong();
        this.isQuery = reader.readBoolean();
        if (this.isQuery) {
            this.last = reader.readBoolean();
            this.items = JdbcUtils.readItems(reader);
        } else {
            this.last = true;
            this.updateCnt = reader.readLong();
        }
        if (reader.readBoolean()) {
            this.partRes = PartitionResultMarshaler.unmarshal(reader);
        }
    }

    public PartitionResult partitionResult() {
        return this.partRes;
    }

    @Override
    public String toString() {
        return S.toString(JdbcQueryExecuteResult.class, this, super.toString());
    }
}

