/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.odbc.ClientListenerNioServerBuffer;
import org.apache.ignite.internal.util.nio.GridNioParser;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;

public class ClientListenerBufferedParser
implements GridNioParser {
    private static final int BUF_META_KEY = GridNioSessionMetaKey.nextUniqueKey();

    public byte[] decode(GridNioSession ses, ByteBuffer buf) throws IOException, IgniteCheckedException {
        ClientListenerNioServerBuffer nioBuf = (ClientListenerNioServerBuffer)ses.meta(BUF_META_KEY);
        if (nioBuf == null) {
            nioBuf = new ClientListenerNioServerBuffer();
            ClientListenerNioServerBuffer old = ses.addMeta(BUF_META_KEY, nioBuf);
            assert (old == null);
        }
        return nioBuf.read(buf);
    }

    @Override
    public ByteBuffer encode(GridNioSession ses, Object msg) throws IOException, IgniteCheckedException {
        byte[] msg0 = (byte[])msg;
        ByteBuffer res = ByteBuffer.allocate(msg0.length + 4);
        res.order(ByteOrder.LITTLE_ENDIAN);
        res.putInt(msg0.length);
        res.put(msg0);
        res.flip();
        return res;
    }

    public String toString() {
        return ClientListenerBufferedParser.class.getSimpleName();
    }
}

