/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.client;

import java.util.Map;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientAbstractCallable;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgfsClientMkdirsCallable
extends IgfsClientAbstractCallable<Void> {
    private static final long serialVersionUID = 0L;
    private Map<String, String> props;

    public IgfsClientMkdirsCallable() {
    }

    public IgfsClientMkdirsCallable(@Nullable String igfsName, @Nullable String user, IgfsPath path, @Nullable Map<String, String> props) {
        super(igfsName, user, path);
        this.props = props;
    }

    @Override
    protected Void call0(IgfsContext ctx) throws Exception {
        ctx.igfs().mkdirs(this.path, this.props);
        return null;
    }

    @Override
    public void writeBinary0(BinaryRawWriter writer) throws BinaryObjectException {
        IgfsUtils.writeProperties(writer, this.props);
    }

    @Override
    public void readBinary0(BinaryRawReader reader) throws BinaryObjectException {
        this.props = IgfsUtils.readProperties(reader);
    }

    public String toString() {
        return S.toString(IgfsClientMkdirsCallable.class, this);
    }
}

