/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentLockStorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentObservable;

class SegmentArchivedStorage
extends SegmentObservable {
    private final SegmentLockStorage segmentLockStorage;
    private volatile boolean interrupted;
    private volatile long lastAbsArchivedIdx = -1L;
    private volatile long lastTruncatedArchiveIdx = -1L;

    private SegmentArchivedStorage(SegmentLockStorage segmentLockStorage) {
        this.segmentLockStorage = segmentLockStorage;
    }

    static SegmentArchivedStorage buildArchivedStorage(SegmentLockStorage segmentLockStorage) {
        SegmentArchivedStorage archivedStorage = new SegmentArchivedStorage(segmentLockStorage);
        segmentLockStorage.addObserver(archivedStorage::onSegmentUnlocked);
        return archivedStorage;
    }

    long lastArchivedAbsoluteIndex() {
        return this.lastAbsArchivedIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastArchivedAbsoluteIndex(long lastAbsArchivedIdx) {
        SegmentArchivedStorage segmentArchivedStorage = this;
        synchronized (segmentArchivedStorage) {
            this.lastAbsArchivedIdx = lastAbsArchivedIdx;
            this.notifyAll();
        }
        this.notifyObservers(lastAbsArchivedIdx);
    }

    synchronized void awaitSegmentArchived(long awaitIdx) throws IgniteInterruptedCheckedException {
        while (this.lastArchivedAbsoluteIndex() < awaitIdx && !this.interrupted) {
            try {
                this.wait(2000L);
            }
            catch (InterruptedException e) {
                throw new IgniteInterruptedCheckedException(e);
            }
        }
        this.checkInterrupted();
    }

    synchronized void markAsMovedToArchive(long toArchive) throws IgniteInterruptedCheckedException {
        try {
            while (this.segmentLockStorage.locked(toArchive) && !this.interrupted) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException(e);
        }
        this.setLastArchivedAbsoluteIndex(toArchive);
    }

    synchronized void interrupt() {
        this.interrupted = true;
        this.notifyAll();
    }

    void reset() {
        this.interrupted = false;
    }

    private void checkInterrupted() throws IgniteInterruptedCheckedException {
        if (this.interrupted) {
            throw new IgniteInterruptedCheckedException("Interrupt waiting of change archived idx");
        }
    }

    private synchronized void onSegmentUnlocked(long segmentId) {
        this.notifyAll();
    }

    void lastTruncatedArchiveIdx(long lastTruncatedArchiveIdx) {
        this.lastTruncatedArchiveIdx = lastTruncatedArchiveIdx;
    }

    long lastTruncatedArchiveIdx() {
        return this.lastTruncatedArchiveIdx;
    }
}

