/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.metastorage;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageDataRow;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageRowStore;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetsatorageSearchRowImpl;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.jetbrains.annotations.Nullable;

public class MetastorageTree
extends BPlusTree<MetastorageSearchRow, MetastorageDataRow> {
    public static final int MAX_KEY_LEN = 64;
    private MetastorageRowStore rowStore;
    private final int partId;

    public MetastorageTree(int cacheId, String name, PageMemory pageMem, IgniteWriteAheadLogManager wal, AtomicLong globalRmvId, ReuseList reuseList, MetastorageRowStore rowStore, long metaPageId, boolean initNew, @Nullable FailureProcessor failureProcessor, int partId, @Nullable PageLockListener lockLsnr) throws IgniteCheckedException {
        super(name, cacheId, null, pageMem, wal, globalRmvId, metaPageId, reuseList, MetastorageInnerIO.VERSIONS, MetastoreLeafIO.VERSIONS, failureProcessor, lockLsnr);
        this.rowStore = rowStore;
        this.partId = partId;
        this.initTree(initNew);
    }

    @Override
    protected int compare(BPlusIO<MetastorageSearchRow> io, long pageAddr, int idx, MetastorageSearchRow row) {
        String key = ((DataLinkIO)((Object)io)).getKey(pageAddr, idx);
        return key.compareTo(row.key());
    }

    @Override
    public MetastorageDataRow getRow(BPlusIO<MetastorageSearchRow> io, long pageAddr, int idx, Object x) throws IgniteCheckedException {
        long link = ((DataLinkIO)((Object)io)).getLink(pageAddr, idx);
        String key = ((DataLinkIO)((Object)io)).getKey(pageAddr, idx);
        return this.rowStore.dataRow(key, link);
    }

    public MetastorageRowStore rowStore() {
        return this.rowStore;
    }

    @Override
    protected long allocatePageNoReuse() throws IgniteCheckedException {
        return this.pageMem.allocatePage(this.grpId, this.partId, (byte)1);
    }

    public static class MetastoreLeafIO
    extends BPlusLeafIO<MetastorageSearchRow>
    implements DataLinkIO {
        public static final IOVersions<MetastoreLeafIO> VERSIONS = new IOVersions((PageIO[])new MetastoreLeafIO[]{new MetastoreLeafIO(1)});

        MetastoreLeafIO(int ver) {
            super(23, ver, 74);
        }

        @Override
        public void storeByOffset(long pageAddr, int off, MetastorageSearchRow row) {
            assert (row.link() != 0L);
            PageUtils.putLong(pageAddr, off, row.link());
            byte[] bytes = row.key().getBytes();
            assert (bytes.length <= 64);
            PageUtils.putShort(pageAddr, off + 8, (short)bytes.length);
            PageUtils.putBytes(pageAddr, off + 10, bytes);
        }

        @Override
        public void store(long dstPageAddr, int dstIdx, BPlusIO<MetastorageSearchRow> srcIo, long srcPageAddr, int srcIdx) {
            int srcOff = srcIo.offset(srcIdx);
            int dstOff = this.offset(dstIdx);
            long link = ((DataLinkIO)((Object)srcIo)).getLink(srcPageAddr, srcIdx);
            short len = ((DataLinkIO)((Object)srcIo)).getKeySize(srcPageAddr, srcIdx);
            byte[] payload = PageUtils.getBytes(srcPageAddr, srcOff + 10, len);
            PageUtils.putLong(dstPageAddr, dstOff, link);
            PageUtils.putShort(dstPageAddr, dstOff + 8, len);
            PageUtils.putBytes(dstPageAddr, dstOff + 10, payload);
        }

        @Override
        public MetastorageSearchRow getLookupRow(BPlusTree<MetastorageSearchRow, ?> tree, long pageAddr, int idx) {
            long link = this.getLink(pageAddr, idx);
            String key = this.getKey(pageAddr, idx);
            return new MetsatorageSearchRowImpl(key, link);
        }

        @Override
        public long getLink(long pageAddr, int idx) {
            assert (idx < this.getCount(pageAddr)) : idx;
            return PageUtils.getLong(pageAddr, this.offset(idx));
        }

        @Override
        public short getKeySize(long pageAddr, int idx) {
            return PageUtils.getShort(pageAddr, this.offset(idx) + 8);
        }

        @Override
        public String getKey(long pageAddr, int idx) {
            short len = PageUtils.getShort(pageAddr, this.offset(idx) + 8);
            byte[] bytes = PageUtils.getBytes(pageAddr, this.offset(idx) + 10, len);
            return new String(bytes);
        }
    }

    public static class MetastorageInnerIO
    extends BPlusInnerIO<MetastorageSearchRow>
    implements DataLinkIO {
        public static final IOVersions<MetastorageInnerIO> VERSIONS = new IOVersions((PageIO[])new MetastorageInnerIO[]{new MetastorageInnerIO(1)});

        MetastorageInnerIO(int ver) {
            super(22, ver, true, 74);
        }

        @Override
        public void storeByOffset(long pageAddr, int off, MetastorageSearchRow row) {
            assert (row.link() != 0L);
            PageUtils.putLong(pageAddr, off, row.link());
            byte[] bytes = row.key().getBytes();
            assert (bytes.length <= 64);
            PageUtils.putShort(pageAddr, off + 8, (short)bytes.length);
            PageUtils.putBytes(pageAddr, off + 10, bytes);
        }

        @Override
        public void store(long dstPageAddr, int dstIdx, BPlusIO<MetastorageSearchRow> srcIo, long srcPageAddr, int srcIdx) {
            int srcOff = srcIo.offset(srcIdx);
            int dstOff = this.offset(dstIdx);
            long link = ((DataLinkIO)((Object)srcIo)).getLink(srcPageAddr, srcIdx);
            short len = ((DataLinkIO)((Object)srcIo)).getKeySize(srcPageAddr, srcIdx);
            byte[] payload = PageUtils.getBytes(srcPageAddr, srcOff + 10, len);
            PageUtils.putLong(dstPageAddr, dstOff, link);
            PageUtils.putShort(dstPageAddr, dstOff + 8, len);
            PageUtils.putBytes(dstPageAddr, dstOff + 10, payload);
        }

        @Override
        public MetastorageSearchRow getLookupRow(BPlusTree<MetastorageSearchRow, ?> tree, long pageAddr, int idx) {
            long link = this.getLink(pageAddr, idx);
            String key = this.getKey(pageAddr, idx);
            return new MetsatorageSearchRowImpl(key, link);
        }

        @Override
        public long getLink(long pageAddr, int idx) {
            assert (idx < this.getCount(pageAddr)) : idx;
            return PageUtils.getLong(pageAddr, this.offset(idx));
        }

        @Override
        public short getKeySize(long pageAddr, int idx) {
            return PageUtils.getShort(pageAddr, this.offset(idx) + 8);
        }

        @Override
        public String getKey(long pageAddr, int idx) {
            short len = PageUtils.getShort(pageAddr, this.offset(idx) + 8);
            byte[] bytes = PageUtils.getBytes(pageAddr, this.offset(idx) + 10, len);
            return new String(bytes);
        }
    }

    private static interface DataLinkIO {
        public long getLink(long var1, int var3);

        public short getKeySize(long var1, int var3);

        public String getKey(long var1, int var3);
    }
}

